/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import org.jboss.as.process.ManagedProcess;
import org.jboss.as.process.ProcessController;
import org.jboss.as.protocol.old.Connection;
import org.jboss.as.protocol.old.ConnectionHandler;
import org.jboss.as.protocol.old.MessageHandler;
import org.jboss.as.protocol.old.StreamUtils;
import org.jboss.logging.Logger;

public final class ProcessControllerServerHandler
implements ConnectionHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.process-controller.server");
    private final ProcessController processController;

    public ProcessControllerServerHandler(ProcessController controller) {
        this.processController = controller;
    }

    public MessageHandler handleConnected(Connection connection) throws IOException {
        log.tracef("Received connection from %s", (Object)connection.getPeerAddress());
        return new InitMessageHandler(this.processController);
    }

    private static class InitMessageHandler
    implements MessageHandler {
        private final ProcessController processController;

        public InitMessageHandler(ProcessController processController) {
            this.processController = processController;
        }

        public void handleMessage(Connection connection, InputStream dataStream) throws IOException {
            int cmd = StreamUtils.readUnsignedByte((InputStream)dataStream);
            if (cmd != 238) {
                log.warnf("Received unrecognized greeting code 0x%02x from %s", (Object)cmd, (Object)connection.getPeerAddress());
                connection.close();
                return;
            }
            int version = StreamUtils.readUnsignedByte((InputStream)dataStream);
            if (version < 1) {
                log.warnf("Received connection with invalid version from %s", (Object)connection.getPeerAddress());
                connection.close();
                return;
            }
            byte[] authCode = new byte[16];
            StreamUtils.readFully((InputStream)dataStream, (byte[])authCode);
            ManagedProcess process = this.processController.getServerByAuthCode(authCode);
            if (process == null) {
                log.warnf("Received connection with unknown credentials from %s", (Object)connection.getPeerAddress());
                StreamUtils.safeClose((Closeable)connection);
                return;
            }
            log.tracef("Received authentic connection from %s", (Object)connection.getPeerAddress());
            connection.setMessageHandler((MessageHandler)new ConnectedMessageHandler(this.processController, process.isInitial()));
            this.processController.addManagedConnection(connection);
            dataStream.close();
        }

        public void handleShutdown(Connection connection) throws IOException {
            log.tracef("Received end-of-stream for connection", new Object[0]);
            this.processController.removeManagedConnection(connection);
            connection.shutdownWrites();
        }

        public void handleFailure(Connection connection, IOException e) throws IOException {
            log.tracef((Throwable)e, "Received failure of connection", new Object[0]);
            this.processController.removeManagedConnection(connection);
            connection.close();
        }

        public void handleFinished(Connection connection) throws IOException {
            log.tracef("Connection finished", new Object[0]);
            this.processController.removeManagedConnection(connection);
        }

        private static class ConnectedMessageHandler
        implements MessageHandler {
            private final boolean isHostController;
            private final ProcessController processController;

            public ConnectedMessageHandler(ProcessController processController, boolean isHostController) {
                this.processController = processController;
                this.isHostController = isHostController;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void handleMessage(Connection connection, InputStream dataStream) throws IOException {
                try {
                    int cmd = StreamUtils.readUnsignedByte((InputStream)dataStream);
                    switch (cmd) {
                        case 20: {
                            if (this.isHostController) {
                                String processName = StreamUtils.readUTFZBytes((InputStream)dataStream);
                                log.tracef("Received send_stdin for process %s", (Object)processName);
                                this.processController.sendStdin(processName, dataStream);
                            } else {
                                log.tracef("Ignoring send_stdin message from untrusted source", new Object[0]);
                            }
                            dataStream.close();
                            return;
                        }
                        case 16: {
                            if (this.isHostController) {
                                String processName = StreamUtils.readUTFZBytes((InputStream)dataStream);
                                byte[] authKey = new byte[16];
                                StreamUtils.readFully((InputStream)dataStream, (byte[])authKey);
                                int commandCount = StreamUtils.readInt((InputStream)dataStream);
                                String[] command = new String[commandCount];
                                for (int i = 0; i < commandCount; ++i) {
                                    command[i] = StreamUtils.readUTFZBytes((InputStream)dataStream);
                                }
                                int envCount = StreamUtils.readInt((InputStream)dataStream);
                                HashMap<String, String> env = new HashMap<String, String>();
                                for (int i = 0; i < envCount; ++i) {
                                    env.put(StreamUtils.readUTFZBytes((InputStream)dataStream), StreamUtils.readUTFZBytes((InputStream)dataStream));
                                }
                                String workingDirectory = StreamUtils.readUTFZBytes((InputStream)dataStream);
                                log.tracef("Received add_process for process %s", (Object)processName);
                                this.processController.addProcess(processName, Arrays.asList(command), env, workingDirectory, false);
                            } else {
                                log.tracef("Ignoring add_process message from untrusted source", new Object[0]);
                            }
                            dataStream.close();
                            return;
                        }
                        case 17: {
                            if (this.isHostController) {
                                String processName = StreamUtils.readUTFZBytes((InputStream)dataStream);
                                this.processController.startProcess(processName);
                                log.tracef("Received start_process for process %s", (Object)processName);
                            } else {
                                log.tracef("Ignoring start_process message from untrusted source", new Object[0]);
                            }
                            dataStream.close();
                            return;
                        }
                        case 18: {
                            if (this.isHostController) {
                                String processName = StreamUtils.readUTFZBytes((InputStream)dataStream);
                                this.processController.stopProcess(processName);
                            } else {
                                log.tracef("Ignoring stop_process message from untrusted source", new Object[0]);
                            }
                            dataStream.close();
                            return;
                        }
                        case 19: {
                            if (this.isHostController) {
                                String processName = StreamUtils.readUTFZBytes((InputStream)dataStream);
                                this.processController.removeProcess(processName);
                            } else {
                                log.tracef("Ignoring remove_process message from untrusted source", new Object[0]);
                            }
                            dataStream.close();
                            return;
                        }
                        case 21: {
                            if (this.isHostController) {
                                this.processController.sendInventory();
                            } else {
                                log.tracef("Ignoring request_process_inventory message from untrusted source", new Object[0]);
                            }
                            dataStream.close();
                            return;
                        }
                        case 22: {
                            if (this.isHostController) {
                                String processName = StreamUtils.readUTFZBytes((InputStream)dataStream);
                                String hostName = StreamUtils.readUTFZBytes((InputStream)dataStream);
                                int port = StreamUtils.readInt((InputStream)dataStream);
                                this.processController.sendReconnectProcess(processName, hostName, port);
                            } else {
                                log.tracef("Ignoring reconnect_process message from untrusted source", new Object[0]);
                            }
                            dataStream.close();
                            return;
                        }
                        case 23: {
                            if (this.isHostController) {
                                new Thread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ConnectedMessageHandler.this.processController.shutdown();
                                        System.exit(0);
                                    }
                                }).start();
                                return;
                            } else {
                                log.tracef("Ignoring shutdown message from untrusted source", new Object[0]);
                                return;
                            }
                        }
                        default: {
                            log.warnf("Received unknown message with code 0x%02x", (Object)cmd);
                            dataStream.close();
                            return;
                        }
                    }
                }
                finally {
                    StreamUtils.safeClose((Closeable)dataStream);
                }
            }

            public void handleShutdown(Connection connection) throws IOException {
                log.tracef("Received end-of-stream for connection", new Object[0]);
                connection.shutdownWrites();
            }

            public void handleFailure(Connection connection, IOException e) throws IOException {
                log.tracef((Throwable)e, "Received failure of connection", new Object[0]);
                connection.close();
            }

            public void handleFinished(Connection connection) throws IOException {
                log.tracef("Connection finished", new Object[0]);
            }
        }
    }
}

