/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.io.PrintStream;
import org.jboss.as.process.ProcessMessages;

enum CliArgument {
    BACKUP{

        @Override
        public String argument() {
            return "--backup";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argBackup();
        }
    }
    ,
    CACHED_DC{

        @Override
        public String argument() {
            return "--cached-dc";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argCachedDc();
        }
    }
    ,
    SYSTEM_PROPERTY{

        @Override
        public String argument() {
            return "-D";
        }

        @Override
        public String argumentExample() {
            return String.format("%s<name>[=<value>]", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argSystem();
        }
    }
    ,
    DOMAIN_CONFIG{

        @Override
        public String argument() {
            return "--domain-config";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<config>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argDomainConfig();
        }
    }
    ,
    SHORT_HELP{

        @Override
        public String argument() {
            return "-h";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argHelp();
        }
    }
    ,
    HELP{

        @Override
        public String argument() {
            return "--help";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argHelp();
        }
    }
    ,
    HOST_CONFIG{

        @Override
        public String argument() {
            return "--host-config";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<config>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argHostConfig();
        }
    }
    ,
    PC_ADDRESS{

        @Override
        public String argument() {
            return "--pc-address";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<address>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argPcAddress();
        }
    }
    ,
    PC_PORT{

        @Override
        public String argument() {
            return "--pc-port";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<port>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argPcPort();
        }
    }
    ,
    INTERPROCESS_NAME{

        @Override
        public String argument() {
            return "--interprocess-name";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<proc>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argInterProcessName();
        }
    }
    ,
    INTERPROCESS_HC_ADDRESS{

        @Override
        public String argument() {
            return "--interprocess-hc-address";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<address>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argInterProcessHcAddress();
        }
    }
    ,
    INTERPROCESS_HC_PORT{

        @Override
        public String argument() {
            return "--interprocess-hc-port";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<port>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argInterProcessHcPort();
        }
    }
    ,
    SHORT_PROPERTIES{

        @Override
        public String argument() {
            return "-P";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<url>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argProperties();
        }
    }
    ,
    PROPERTIES{

        @Override
        public String argument() {
            return "--properties";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<url>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argProperties();
        }
    }
    ,
    SHORT_VERSION{

        @Override
        public String argument() {
            return "-V";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argVersion();
        }
    }
    ,
    VERSION{

        @Override
        public String argument() {
            return "--version";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argVersion();
        }
    };

    private static String USAGE;

    public abstract String argument();

    public abstract String argumentExample();

    public abstract String instructions();

    public String toString() {
        return String.format("    %-35s %s", this.argumentExample(), this.instructions());
    }

    public static void printUsage(PrintStream out) {
        out.print(CliArgument.usage());
    }

    public static String usage() {
        if (USAGE == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(ProcessMessages.MESSAGES.argUsage()).append("\n");
            for (CliArgument arg : CliArgument.values()) {
                sb.append(arg.toString()).append("\n");
            }
            USAGE = sb.toString();
        }
        return USAGE;
    }
}

