/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.MessageHandler;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.SimpleByteDataInput;
import org.jboss.as.protocol.SimpleByteDataOutput;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestConnectionStrategy;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;

public abstract class ManagementRequest<T>
extends AbstractMessageHandler {
    private int requestId = 0;
    private final ResponseFuture<T> future = new ResponseFuture();
    private ManagementRequestConnectionStrategy connectionStrategy;
    private T result;
    private final Object resultLock = new Object();
    private MessageHandler initiatingMessageHandler = new AbstractMessageHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void handle(Connection connection, InputStream inputStream) throws IOException {
            SimpleByteDataInput input = null;
            try {
                input = new SimpleByteDataInput(inputStream);
                ManagementResponseHeader responseHeader = new ManagementResponseHeader(input);
                int responseId = responseHeader.getResponseId();
                if (responseId == -1) {
                    throw new IOException("Remote side caught an (unknown) exception and cannot process the request");
                }
                if (ManagementRequest.this.requestId != responseId) {
                    throw new IOException("Invalid request ID expecting " + ManagementRequest.this.requestId + " received " + responseHeader.getResponseId());
                }
                connection.setMessageHandler(ManagementRequest.this);
                ManagementRequest.this.sendRequest(responseHeader.getVersion(), connection);
            }
            catch (Exception e) {
                try {
                    ManagementRequest.this.future.setException(e);
                }
                catch (Throwable throwable) {
                    StreamUtils.safeClose(input);
                    if (ManagementRequest.this.future.isDone()) {
                        ManagementRequest.this.connectionStrategy.complete();
                    }
                    throw throwable;
                }
                StreamUtils.safeClose(input);
                if (ManagementRequest.this.future.isDone()) {
                    ManagementRequest.this.connectionStrategy.complete();
                }
            }
            StreamUtils.safeClose(input);
            if (ManagementRequest.this.future.isDone()) {
                ManagementRequest.this.connectionStrategy.complete();
            }
        }
    };
    private MessageHandler responseBodyHandler = new AbstractMessageHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void handle(Connection connection, InputStream input) throws IOException {
            try {
                connection.setMessageHandler(ManagementRequest.this.responseEndHandler);
                byte header = StreamUtils.readByte(input);
                if (header == -1) {
                    throw new IOException("Remote side caught an (unknown) exception and cannot process the request");
                }
                ProtocolUtils.expectHeader(header, 6);
                Object object = ManagementRequest.this.resultLock;
                synchronized (object) {
                    ManagementRequest.this.result = ManagementRequest.this.receiveResponse(input);
                }
            }
            catch (Exception e) {
                ManagementRequest.this.future.setException(e);
            }
        }

        @Override
        public void handleFinished(Connection connection) throws IOException {
            super.handleFinished(connection);
            ManagementRequest.this.future.setException(new EOFException("Connection closed"));
        }

        @Override
        public void handleFailure(Connection connection, IOException e) throws IOException {
            super.handleFailure(connection, e);
            ManagementRequest.this.future.setException(e);
        }
    };
    private MessageHandler responseEndHandler = new AbstractMessageHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void handle(Connection connection, InputStream input) throws IOException {
            try {
                connection.restoreMessageHandler();
                ProtocolUtils.expectHeader(input, 7);
                Object object = ManagementRequest.this.resultLock;
                synchronized (object) {
                    ManagementRequest.this.future.set(ManagementRequest.this.result);
                }
            }
            catch (Exception e) {
                ManagementRequest.this.future.setException(e);
            }
            finally {
                ManagementRequest.this.connectionStrategy.complete();
            }
        }

        @Override
        public void handleFinished(Connection connection) throws IOException {
            super.handleFinished(connection);
            ManagementRequest.this.future.setException(new EOFException("Connection closed"));
        }

        @Override
        public void handleFailure(Connection connection, IOException e) throws IOException {
            super.handleFailure(connection, e);
            ManagementRequest.this.future.setException(e);
        }
    };

    protected abstract byte getHandlerId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<T> execute(ManagementRequestConnectionStrategy connectionStrategy) throws IOException {
        this.connectionStrategy = connectionStrategy;
        OutputStream dataOutput = null;
        SimpleByteDataOutput output = null;
        try {
            Connection connection = connectionStrategy.getConnection();
            connection.backupMessageHandler();
            connection.setMessageHandler(this.initiatingMessageHandler);
            dataOutput = connection.writeMessage();
            output = new SimpleByteDataOutput(dataOutput);
            ManagementRequestHeader managementRequestHeader = new ManagementRequestHeader(1, this.requestId, this.getHandlerId());
            managementRequestHeader.write(output);
            connection.setMessageHandler(this.initiatingMessageHandler);
            output.close();
            dataOutput.close();
        }
        catch (Throwable throwable) {
            StreamUtils.safeClose(output);
            StreamUtils.safeClose(dataOutput);
            throw throwable;
        }
        StreamUtils.safeClose(output);
        StreamUtils.safeClose(dataOutput);
        return this.future;
    }

    public T executeForResult(ManagementRequestConnectionStrategy connectionStrategy) throws Exception {
        return this.execute(connectionStrategy).get();
    }

    @Override
    public void handle(Connection connection, InputStream input) throws IOException {
        try {
            connection.setMessageHandler(this.responseBodyHandler);
            byte header = StreamUtils.readByte(input);
            if (header == -1) {
                throw new IOException("Remote side caught an (unknown) exception and cannot process the request");
            }
            ProtocolUtils.expectHeader(header, 5);
            byte responseCode = StreamUtils.readByte(input);
            if (responseCode != this.getResponseCode()) {
                throw new IOException("Invalid response code.  Expecting '" + this.getResponseCode() + "' received '" + responseCode + "'");
            }
        }
        catch (Exception e) {
            this.future.setException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendRequest(int protocolVersion, Connection connection) throws IOException {
        OutputStream outputStream = null;
        SimpleByteDataOutput output = null;
        try {
            outputStream = connection.writeMessage();
            output = new SimpleByteDataOutput(outputStream);
            output.writeByte(2);
            output.writeByte(this.getRequestCode());
            output.writeByte(1);
            output.close();
            outputStream.close();
        }
        catch (Throwable throwable) {
            StreamUtils.safeClose(output);
            StreamUtils.safeClose(outputStream);
            throw throwable;
        }
        StreamUtils.safeClose(output);
        StreamUtils.safeClose(outputStream);
        try {
            outputStream = connection.writeMessage();
            outputStream.write(3);
            this.sendRequest(protocolVersion, outputStream);
            outputStream.close();
        }
        finally {
            StreamUtils.safeClose(outputStream);
        }
        try {
            outputStream = connection.writeMessage();
            output = new SimpleByteDataOutput(outputStream);
            output.writeByte(4);
            output.close();
            outputStream.close();
        }
        finally {
            StreamUtils.safeClose(output);
            StreamUtils.safeClose(outputStream);
        }
    }

    protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
    }

    protected abstract byte getRequestCode();

    protected abstract byte getResponseCode();

    protected T receiveResponse(InputStream input) throws IOException {
        return null;
    }

    private final class ResponseFuture<R>
    implements Future<R> {
        private volatile R result;
        private volatile Exception exception;
        private AtomicBoolean valueSet = new AtomicBoolean();

        private ResponseFuture() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public R get() throws InterruptedException, ExecutionException {
            boolean intr = false;
            try {
                ResponseFuture<R> responseFuture = this;
                synchronized (responseFuture) {
                    while (!this.valueSet.get()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            intr = true;
                        }
                    }
                }
                if (this.exception != null) {
                    throw new ExecutionException(this.exception);
                }
                responseFuture = this.result;
                return (R)responseFuture;
            }
            finally {
                if (intr) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void set(R result) {
            ResponseFuture responseFuture = this;
            synchronized (responseFuture) {
                if (this.valueSet.compareAndSet(false, true)) {
                    this.result = result;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setException(Exception exception) {
            ResponseFuture responseFuture = this;
            synchronized (responseFuture) {
                if (this.valueSet.compareAndSet(false, true)) {
                    this.exception = exception;
                    this.notifyAll();
                }
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public synchronized boolean isDone() {
            return this.result != null || this.exception != null;
        }

        @Override
        public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }
    }
}

