/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.old;

import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.Executor;
import org.jboss.as.protocol.ProtocolLogger;
import org.jboss.as.protocol.ProtocolMessages;
import org.jboss.as.protocol.old.Connection;
import org.jboss.as.protocol.old.MessageHandler;
import org.jboss.as.protocol.old.StreamUtils;

final class ConnectionImpl
implements Connection {
    private final Socket socket;
    private final Object lock = new Object();
    private OutputStream sender;
    private boolean readDone;
    private boolean writeDone;
    private volatile MessageHandler messageHandler;
    private final Executor readExecutor;
    private volatile Object attachment;
    private volatile MessageHandler backupHandler;
    private final Connection.ClosedCallback callback;

    ConnectionImpl(Socket socket, MessageHandler handler, Executor readExecutor, Connection.ClosedCallback callback) {
        this.socket = socket;
        this.messageHandler = handler;
        this.readExecutor = readExecutor;
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream writeMessage() throws IOException {
        BufferedOutputStream os;
        Object object = this.lock;
        synchronized (object) {
            if (this.writeDone) {
                throw ProtocolMessages.MESSAGES.writesAlreadyShutdown();
            }
            while (this.sender != null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            boolean ok = false;
            try {
                this.sender = new MessageOutputStream();
                os = new BufferedOutputStream(this.sender);
                ok = true;
            }
            finally {
                if (!ok) {
                    this.lock.notify();
                }
            }
        }
        return os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownWrites() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.writeDone) {
                return;
            }
            while (this.sender != null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            this.writeDone = true;
            if (this.readDone) {
                this.socket.close();
            } else {
                this.socket.shutdownOutput();
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
            this.sender = null;
            this.readDone = true;
            this.writeDone = true;
            this.socket.close();
            this.lock.notifyAll();
        }
    }

    @Override
    public void setMessageHandler(MessageHandler messageHandler) {
        if (messageHandler == null) {
            throw ProtocolMessages.MESSAGES.nullVar("messageHandler");
        }
        this.messageHandler = messageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress getPeerAddress() {
        Object object = this.lock;
        synchronized (object) {
            Socket socket = this.socket;
            if (socket != null) {
                return socket.getInetAddress();
            }
            return null;
        }
    }

    @Override
    public void attach(Object attachment) {
        this.attachment = attachment;
    }

    @Override
    public Object getAttachment() {
        return this.attachment;
    }

    @Override
    public void backupMessageHandler() {
        this.backupHandler = this.messageHandler;
    }

    @Override
    public void restoreMessageHandler() {
        MessageHandler handler = this.backupHandler;
        this.setMessageHandler(handler == null ? MessageHandler.NULL : handler);
    }

    Runnable getReadTask() {
        return new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[CASE]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
    }

    void safeHandleMessage(InputStream pis) {
        try {
            this.messageHandler.handleMessage(this, pis);
        }
        catch (RuntimeException e) {
            ProtocolLogger.CONNECTION_LOGGER.failedToReadMessage(e);
        }
        catch (IOException e) {
            ProtocolLogger.CONNECTION_LOGGER.failedToReadMessage(e);
        }
        catch (NoClassDefFoundError e) {
            ProtocolLogger.CONNECTION_LOGGER.failedToReadMessage(e);
        }
        catch (Error e) {
            ProtocolLogger.CONNECTION_LOGGER.failedToReadMessage(e);
            throw e;
        }
        finally {
            StreamUtils.safeClose(pis);
        }
    }

    void safeHandleShutdown() {
        try {
            this.messageHandler.handleShutdown(this);
        }
        catch (IOException e) {
            ProtocolLogger.CONNECTION_LOGGER.failedToHandleSocketShutdown(e);
        }
    }

    void safeHandleFinished() {
        try {
            this.messageHandler.handleFinished(this);
        }
        catch (IOException e) {
            ProtocolLogger.CONNECTION_LOGGER.failedToHandleSocketFinished(e);
        }
    }

    void safeHandlerFailure(IOException e) {
        try {
            this.messageHandler.handleFailure(this, e);
        }
        catch (IOException e1) {
            ProtocolLogger.CONNECTION_LOGGER.failedToHandleSocketFailure(e);
        }
    }

    private void closed() {
        Connection.ClosedCallback callback = this.callback;
        if (callback != null) {
            callback.connectionClosed();
        }
    }

    static /* synthetic */ boolean access$202(ConnectionImpl x0, boolean x1) {
        x0.readDone = x1;
        return x0.readDone;
    }

    static /* synthetic */ void access$400(ConnectionImpl x0) {
        x0.closed();
    }

    final class MessageOutputStream
    extends FilterOutputStream {
        private final byte[] hdr;

        MessageOutputStream() throws IOException {
            super(ConnectionImpl.this.socket.getOutputStream());
            this.hdr = new byte[5];
        }

        @Override
        public void write(int b) throws IOException {
            throw new IllegalStateException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return;
            }
            byte[] hdr = this.hdr;
            hdr[0] = -104;
            hdr[1] = (byte)(len >> 24);
            hdr[2] = (byte)(len >> 16);
            hdr[3] = (byte)(len >> 8);
            hdr[4] = (byte)(len >> 0);
            Object object = ConnectionImpl.this.lock;
            synchronized (object) {
                if (ConnectionImpl.this.sender != this || ConnectionImpl.this.writeDone) {
                    if (ConnectionImpl.this.sender == this) {
                        ConnectionImpl.this.sender = null;
                    }
                    ConnectionImpl.this.lock.notifyAll();
                    throw ProtocolMessages.MESSAGES.writeChannelClosed();
                }
                ProtocolLogger.CONNECTION_LOGGER.tracef("Sending data chunk of size %d", len);
                this.out.write(hdr);
                this.out.write(b, off, len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = ConnectionImpl.this.lock;
            synchronized (object) {
                if (ConnectionImpl.this.sender != this) {
                    return;
                }
                ConnectionImpl.this.sender = null;
                ConnectionImpl.this.lock.notify();
                if (ConnectionImpl.this.writeDone) {
                    throw ProtocolMessages.MESSAGES.writeChannelClosed();
                }
                if (ConnectionImpl.this.readDone) {
                    ConnectionImpl.this.readExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            ConnectionImpl.this.safeHandleFinished();
                        }
                    });
                }
                ProtocolLogger.CONNECTION_LOGGER.tracef("Sending end of message", new Object[0]);
                this.out.write(153);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            super.finalize();
            Object object = ConnectionImpl.this.lock;
            synchronized (object) {
                if (ConnectionImpl.this.sender == this) {
                    ProtocolLogger.CONNECTION_LOGGER.leakedMessageOutputStream();
                    this.close();
                }
            }
        }
    }

    final class MessageInputStream
    extends FilterInputStream {
        protected MessageInputStream(InputStream in) {
            super(in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                while (this.in.read() != -1) {
                }
            }
            finally {
                super.close();
            }
        }
    }
}

