/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.as.protocol.ProtocolLogger;
import org.jboss.as.protocol.ProtocolMessages;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Property;
import org.xnio.Sequence;

public class ProtocolChannelClient
implements Closeable {
    private static final String JBOSS_LOCAL_USER = "JBOSS-LOCAL-USER";
    private final Endpoint endpoint;
    private final Configuration configuration;
    private final URI uri;

    private ProtocolChannelClient(Endpoint endpoint, Configuration configuration) {
        this.endpoint = endpoint;
        this.configuration = configuration;
        this.uri = configuration.getUri();
    }

    public static ProtocolChannelClient create(Configuration configuration) throws IOException {
        if (configuration == null) {
            throw ProtocolMessages.MESSAGES.nullVar("configuration");
        }
        configuration.validate();
        Endpoint endpoint = configuration.getEndpoint();
        return new ProtocolChannelClient(endpoint, configuration);
    }

    public IoFuture<Connection> connect(CallbackHandler handler) throws IOException {
        return this.connect(handler, null, null);
    }

    public IoFuture<Connection> connect(CallbackHandler handler, Map<String, String> saslOptions, SSLContext sslContext) throws IOException {
        OptionMap.Builder builder = OptionMap.builder();
        builder.addAll(this.configuration.getOptionMap());
        builder.set(Options.SASL_POLICY_NOANONYMOUS, (Object)Boolean.FALSE);
        builder.set(Options.SASL_POLICY_NOPLAINTEXT, (Object)Boolean.FALSE);
        if (!this.isLocal()) {
            builder.set(Options.SASL_DISALLOWED_MECHANISMS, (Object)Sequence.of((Object[])new String[]{JBOSS_LOCAL_USER}));
        }
        ArrayList<Property> tempProperties = new ArrayList<Property>(saslOptions != null ? saslOptions.size() : 1);
        tempProperties.add(Property.of((String)"jboss.sasl.local-user.quiet-auth", (String)"true"));
        if (saslOptions != null) {
            for (String currentKey : saslOptions.keySet()) {
                tempProperties.add(Property.of((String)currentKey, (String)saslOptions.get(currentKey)));
            }
        }
        builder.set(Options.SASL_PROPERTIES, (Object)Sequence.of(tempProperties));
        builder.set(Options.SSL_ENABLED, true);
        builder.set(Options.SSL_STARTTLS, true);
        CallbackHandler actualHandler = handler != null ? handler : new AnonymousCallbackHandler();
        return this.endpoint.connect(this.uri, builder.getMap(), actualHandler, sslContext);
    }

    public Connection connectSync(CallbackHandler handler) throws IOException {
        return this.connectSync(handler, null, null);
    }

    public Connection connectSync(CallbackHandler handler, Map<String, String> saslOptions, SSLContext sslContext) throws IOException {
        CallbackHandler actualHandler = handler != null ? handler : new AnonymousCallbackHandler();
        WrapperCallbackHandler wrapperHandler = new WrapperCallbackHandler(actualHandler);
        IoFuture<Connection> future = this.connect(wrapperHandler, saslOptions, sslContext);
        long timeoutMillis = this.configuration.getConnectionTimeout();
        IoFuture.Status status = future.await(timeoutMillis, TimeUnit.MILLISECONDS);
        while (status == IoFuture.Status.WAITING) {
            if (wrapperHandler.isInCall()) {
                status = future.await(timeoutMillis, TimeUnit.MILLISECONDS);
                continue;
            }
            long lastInteraction = wrapperHandler.getCallFinished();
            if (lastInteraction > 0L) {
                long now = System.currentTimeMillis();
                long timeSinceLast = now - lastInteraction;
                if (timeSinceLast < timeoutMillis) {
                    status = future.await(timeoutMillis - timeSinceLast, TimeUnit.MILLISECONDS);
                    continue;
                }
                status = null;
                continue;
            }
            status = null;
        }
        if (status == IoFuture.Status.DONE) {
            return (Connection)future.get();
        }
        if (status == IoFuture.Status.FAILED) {
            throw ProtocolMessages.MESSAGES.failedToConnect(this.uri, future.getException());
        }
        throw ProtocolMessages.MESSAGES.couldNotConnect(this.uri);
    }

    private boolean isLocal() {
        try {
            String hostName = this.uri.getHost();
            InetAddress address = InetAddress.getByName(hostName);
            NetworkInterface nic = NetworkInterface.getByInetAddress(address);
            return address.isLoopbackAddress() || nic != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void close() {
    }

    private static final class AnonymousCallbackHandler
    implements CallbackHandler {
        private AnonymousCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (!(current instanceof NameCallback)) {
                    throw new UnsupportedCallbackException(current);
                }
                NameCallback ncb = (NameCallback)current;
                ncb.setName("anonymous");
            }
        }
    }

    private static final class WrapperCallbackHandler
    implements CallbackHandler {
        private volatile boolean inCall = false;
        private volatile long callFinished = -1L;
        private final CallbackHandler wrapped;

        WrapperCallbackHandler(CallbackHandler toWrap) {
            this.wrapped = toWrap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            this.inCall = true;
            try {
                this.wrapped.handle(callbacks);
            }
            finally {
                this.callFinished = System.currentTimeMillis();
                this.inCall = false;
            }
        }

        boolean isInCall() {
            return this.inCall;
        }

        long getCallFinished() {
            return this.callFinished;
        }
    }

    public static final class Configuration {
        private static final long DEFAULT_CONNECT_TIMEOUT = 5000L;
        private URI uri;
        private Endpoint endpoint;
        private OptionMap optionMap = OptionMap.EMPTY;
        private long connectionTimeout = 5000L;
        private static volatile boolean warnedExecutor;
        private static volatile boolean warnedConnectTimeout;
        private static volatile boolean warnedConnectTimeoutProperty;

        void validate() {
            if (this.endpoint == null) {
                throw ProtocolMessages.MESSAGES.nullVar("endpoint");
            }
            if (this.optionMap == null) {
                throw ProtocolMessages.MESSAGES.nullVar("optionMap");
            }
            if (this.uri == null) {
                throw ProtocolMessages.MESSAGES.nullVar("uri");
            }
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        public OptionMap getOptionMap() {
            return this.optionMap;
        }

        public void setOptionMap(OptionMap optionMap) {
            this.optionMap = optionMap;
        }

        public URI getUri() {
            return this.uri;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }

        public long getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public void setConnectionTimeout(long connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        @Deprecated
        public void setExecutor(Executor readExecutor) {
            boolean warned = warnedExecutor;
            if (!warned) {
                warnedExecutor = true;
                ProtocolLogger.CLIENT_LOGGER.executorNotNeeded();
            }
        }
    }
}

