/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.remoting.ConnectorService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.RemotingSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.SaslQop;
import org.jboss.xnio.SaslStrength;
import org.jboss.xnio.Sequence;

public class ConnectorAdd
implements ModelAddOperationHandler,
DescriptionProvider {
    static final ConnectorAdd INSTANCE = new ConnectorAdd();

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        final String name = address.getLastElement().getValue();
        ConnectorAdd.applyToModel(context.getSubModel(), operation);
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget target = context.getServiceTarget();
                    ConnectorService connectorService = new ConnectorService();
                    connectorService.setOptionMap(ConnectorAdd.createOptionMap(operation));
                    ServiceName connectorName = RemotingServices.connectorServiceName(name);
                    try {
                        target.addService(connectorName, (Service)connectorService).addDependency(connectorName.append(new String[]{"auth-provider"}), ServerAuthenticationProvider.class, connectorService.getAuthenticationProviderInjector()).addDependency(RemotingServices.ENDPOINT, Endpoint.class, connectorService.getEndpointInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
                        resultHandler.handleResultComplete();
                    }
                    catch (ServiceRegistryException e) {
                        throw new OperationFailedException(new ModelNode().set(e.getLocalizedMessage()));
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        ModelNode compensating = Util.getResourceRemoveOperation((ModelNode)operation.require("address"));
        return new BasicOperationResult(compensating);
    }

    static void applyToModel(ModelNode subModel, ModelNode parameters) {
        subModel.get("socket-binding").set(parameters.require("socket-binding"));
        if (parameters.hasDefined("authentication-provider")) {
            subModel.get("authentication-provider").set(parameters.get("authentication-provider"));
        }
        if (parameters.hasDefined("sasl")) {
            subModel.get("sasl").set(parameters.get("sasl"));
        }
        if (parameters.hasDefined("properties")) {
            subModel.get("properties").set(parameters.get("properties"));
        }
    }

    static OptionMap createOptionMap(ModelNode parameters) {
        OptionMap.Builder builder = OptionMap.builder();
        if (parameters.hasDefined("sasl")) {
            ModelNode sasl = parameters.require("sasl");
            builder.set(Options.SASL_SERVER_AUTH, sasl.get("server-auth").asBoolean());
            builder.set(Options.SASL_STRENGTH, (Object)SaslStrength.valueOf((String)sasl.get("strength").asString()));
            builder.set(Options.SASL_QOP, (Object)Sequence.of(ConnectorAdd.asQopSet(sasl.get("qop"))));
            builder.set(Options.SASL_MECHANISMS, (Object)Sequence.of(ConnectorAdd.asStringSet(sasl.get("include-mechanisms"))));
            if (sasl.hasDefined("policy")) {
                ModelNode policy = sasl.require("policy");
                builder.set(Options.SASL_POLICY_FORWARD_SECRECY, policy.get("forward-secrecy").asBoolean());
                builder.set(Options.SASL_POLICY_NOACTIVE, policy.get("no-active").asBoolean());
                builder.set(Options.SASL_POLICY_NOANONYMOUS, policy.get("no-anonymous").asBoolean());
                builder.set(Options.SASL_POLICY_NODICTIONARY, policy.get("no-dictionary").asBoolean());
                builder.set(Options.SASL_POLICY_NOPLAINTEXT, policy.get("no-plaintext").asBoolean());
                builder.set(Options.SASL_POLICY_PASS_CREDENTIALS, policy.get("pass-credentials").asBoolean());
            }
        }
        return builder.getMap();
    }

    static Collection<String> asStringSet(ModelNode node) {
        HashSet<String> set = new HashSet<String>();
        for (ModelNode element : node.asList()) {
            set.add(element.asString());
        }
        return set;
    }

    static Collection<SaslQop> asQopSet(ModelNode node) {
        HashSet<SaslQop> set = new HashSet<SaslQop>();
        for (ModelNode element : node.asList()) {
            set.add(SaslQop.valueOf((String)element.asString()));
        }
        return set;
    }

    public ModelNode getModelDescription(Locale locale) {
        return RemotingSubsystemProviders.CONNECTOR_ADD.getModelDescription(locale);
    }
}

