/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.security.Principal;
import java.util.Set;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.security.CacheableManager;
import org.jboss.security.SimplePrincipal;

class SecurityDomainOperations {
    static final String LIST_CACHED_PRINCIPALS = "list-cached-principals";
    static final String FLUSH_CACHE = "flush-cache";
    private static final String PRINCIPAL_ARGUMENT = "principal";
    static final ModelQueryOperationHandler LIST_CACHED_PRINCIPALS_OP = new ModelQueryOperationHandler(){

        public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
            ModelNode opAddr = operation.require("address");
            PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
            final String securityDomain = address.getLastElement().getValue();
            if (context.getRuntimeContext() != null) {
                context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                    public void execute(RuntimeTaskContext context) throws OperationFailedException {
                        ServiceController controller = context.getServiceRegistry().getRequiredService(SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomain}));
                        if (controller != null) {
                            SecurityDomainContext sdc = (SecurityDomainContext)controller.getValue();
                            CacheableManager manager = (CacheableManager)sdc.getAuthenticationManager();
                            Set cachedPrincipals = manager.getCachedKeys();
                            ModelNode result = new ModelNode();
                            for (Principal principal : cachedPrincipals) {
                                result.add(principal.getName());
                            }
                            if (!result.isDefined()) {
                                result.setEmptyList();
                            }
                            resultHandler.handleResultFragment(new String[0], result);
                            resultHandler.handleResultComplete();
                        } else {
                            resultHandler.handleResultFragment(new String[0], new ModelNode().set("authentication cache for security domain " + securityDomain + " available"));
                            resultHandler.handleResultComplete();
                        }
                    }
                });
            } else {
                resultHandler.handleResultFragment(new String[0], new ModelNode().set("authentication cache for security domain " + securityDomain + " available"));
                resultHandler.handleResultComplete();
            }
            return new BasicOperationResult();
        }
    };
    static final ModelQueryOperationHandler FLUSH_CACHE_OP = new ModelQueryOperationHandler(){

        public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
            ModelNode opAddr = operation.require("address");
            PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
            final String securityDomain = address.getLastElement().getValue();
            String principal = null;
            if (operation.hasDefined(SecurityDomainOperations.PRINCIPAL_ARGUMENT)) {
                principal = operation.get(SecurityDomainOperations.PRINCIPAL_ARGUMENT).asString();
            }
            final String principalName = principal;
            if (context.getRuntimeContext() != null) {
                context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                    public void execute(RuntimeTaskContext context) throws OperationFailedException {
                        ServiceController controller = context.getServiceRegistry().getRequiredService(SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomain}));
                        if (controller != null) {
                            SecurityDomainContext sdc = (SecurityDomainContext)controller.getValue();
                            CacheableManager manager = (CacheableManager)sdc.getAuthenticationManager();
                            if (principalName != null) {
                                manager.flushCache((Object)new SimplePrincipal(principalName));
                            } else {
                                manager.flushCache();
                            }
                            resultHandler.handleResultComplete();
                        } else {
                            resultHandler.handleResultFragment(new String[0], new ModelNode().set("authentication cache for security domain " + securityDomain + " available"));
                            resultHandler.handleResultComplete();
                        }
                    }
                });
            } else {
                resultHandler.handleResultFragment(new String[0], new ModelNode().set("authentication cache for security domain " + securityDomain + " available"));
                resultHandler.handleResultComplete();
            }
            return new BasicOperationResult();
        }
    };

    SecurityDomainOperations() {
    }
}

