/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.HashMap;
import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.security.PropertiesAttributeDefinition;
import org.jboss.as.security.SecurityExtension;
import org.jboss.as.security.service.SecurityVaultService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class VaultResourceDefinition
extends SimpleResourceDefinition {
    public static final VaultResourceDefinition INSTANCE = new VaultResourceDefinition();
    public static final SimpleAttributeDefinition CODE = new SimpleAttributeDefinitionBuilder("code", ModelType.STRING, true).build();
    public static final PropertiesAttributeDefinition OPTIONS = new PropertiesAttributeDefinition("options", "vault-option", true);

    private VaultResourceDefinition() {
        super(PathElement.pathElement((String)"vault", (String)"classic"), SecurityExtension.getResourceDescriptionResolver("vault"), (OperationStepHandler)VaultResourceDefinitionAdd.INSTANCE, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)OPTIONS, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{OPTIONS}));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CODE, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{CODE}));
    }

    static class VaultResourceDefinitionAdd
    extends AbstractBoottimeAddStepHandler {
        static final VaultResourceDefinitionAdd INSTANCE = new VaultResourceDefinitionAdd();

        VaultResourceDefinitionAdd() {
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            CODE.validateAndSet(operation, model);
            OPTIONS.validateAndSet(operation, model);
        }

        protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
            HashMap<String, Object> vaultOptions = new HashMap<String, Object>();
            String vaultClass = null;
            ModelNode vaultNode = operation;
            vaultClass = vaultNode.get("code").asString();
            List vaultOptionList = vaultNode.get("vault-option").asList();
            if (vaultOptionList != null) {
                for (ModelNode vaultOptionNode : vaultOptionList) {
                    Property vaultProp = vaultOptionNode.asProperty();
                    vaultOptions.put(vaultProp.getName(), vaultProp.getValue().asString());
                }
            }
            if (vaultClass != null || !vaultOptions.isEmpty()) {
                SecurityVaultService vaultService = new SecurityVaultService(vaultClass, vaultOptions);
                newControllers.add(context.getServiceTarget().addService(SecurityVaultService.SERVICE_NAME, (Service)vaultService).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
            }
        }
    }
}

