/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.service;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import org.jboss.as.security.SecurityMessages;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

class SecurityActions {
    SecurityActions() {
    }

    static ModuleClassLoader getModuleClassLoader(final String moduleSpec) throws ModuleLoadException {
        if (System.getSecurityManager() != null) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<ModuleClassLoader>(){

                    @Override
                    public ModuleClassLoader run() throws ModuleLoadException {
                        ModuleLoader loader = Module.getCallerModuleLoader();
                        ModuleIdentifier identifier = ModuleIdentifier.fromString((String)moduleSpec);
                        return loader.loadModule(identifier).getClassLoader();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw SecurityMessages.MESSAGES.moduleLoadException(pae);
            }
        }
        ModuleLoader loader = Module.getCallerModuleLoader();
        ModuleIdentifier identifier = ModuleIdentifier.fromString((String)moduleSpec);
        return loader.loadModule(identifier).getClassLoader();
    }

    static void setSecurityProperty(final String key, final String value) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Security.setProperty(key, value);
                    return null;
                }
            });
        } else {
            Security.setProperty(key, value);
        }
    }

    static String getSystemProperty(final String name, final String defaultValue) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(name, defaultValue);
                }
            });
        }
        return System.getProperty(name, defaultValue);
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        return Thread.currentThread().getContextClassLoader();
    }

    static Class<?> loadClass(final String name) throws ClassNotFoundException {
        if (System.getSecurityManager() != null) {
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                    @Override
                    public Class<?> run() throws ClassNotFoundException {
                        ClassLoader[] cls = new ClassLoader[]{SecurityActions.class.getClassLoader(), SecurityActions.getContextClassLoader(), ClassLoader.getSystemClassLoader()};
                        ClassNotFoundException e = null;
                        for (ClassLoader cl : cls) {
                            if (cl == null) continue;
                            try {
                                return cl.loadClass(name);
                            }
                            catch (ClassNotFoundException ce) {
                                e = ce;
                            }
                        }
                        throw e != null ? e : SecurityMessages.MESSAGES.cnfe(name);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw SecurityMessages.MESSAGES.cnfeThrow(name, pae);
            }
        }
        ClassLoader[] cls = new ClassLoader[]{SecurityActions.class.getClassLoader(), SecurityActions.getContextClassLoader(), ClassLoader.getSystemClassLoader()};
        ClassNotFoundException e = null;
        for (ClassLoader cl : cls) {
            if (cl == null) continue;
            try {
                return cl.loadClass(name);
            }
            catch (ClassNotFoundException ce) {
                e = ce;
            }
        }
        throw e != null ? e : SecurityMessages.MESSAGES.cnfe(name);
    }
}

