/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.annotation;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jandex.Index;

public class CompositeIndexProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ResourceRoot deploymentRoot;
        List resourceRoots;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Boolean computeCompositeIndex = deploymentUnit.getAttachment(Attachments.COMPUTE_COMPOSITE_ANNOTATION_INDEX);
        if (computeCompositeIndex != null && !computeCompositeIndex.booleanValue()) {
            return;
        }
        ArrayList<ResourceRoot> allResourceRoots = new ArrayList<ResourceRoot>();
        Boolean processChildren = deploymentUnit.getAttachment(Attachments.PROCESS_CHILD_ANNOTATION_INDEX);
        if ((processChildren == null || processChildren.booleanValue()) && (resourceRoots = (List)deploymentUnit.getAttachment(Attachments.RESOURCE_ROOTS)) != null) {
            for (ResourceRoot resourceRoot : resourceRoots) {
                if (SubDeploymentMarker.isSubDeployment(resourceRoot) || !ModuleRootMarker.isModuleRoot(resourceRoot)) continue;
                allResourceRoots.add(resourceRoot);
            }
        }
        if (ModuleRootMarker.isModuleRoot(deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT))) {
            allResourceRoots.add(deploymentRoot);
        }
        ArrayList<Index> indexes = new ArrayList<Index>(allResourceRoots.size());
        for (ResourceRoot resourceRoot : allResourceRoots) {
            Index index = resourceRoot.getAttachment(Attachments.ANNOTATION_INDEX);
            if (index == null) continue;
            indexes.add(index);
        }
        deploymentUnit.putAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX, new CompositeIndex(indexes));
    }

    @Override
    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
    }
}

