/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.server.deployment.module.FilterSpecification;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilter;

public final class ModuleDependency
implements Serializable {
    private static final long serialVersionUID = 2749276798703740853L;
    private final ModuleLoader moduleLoader;
    private final ModuleIdentifier identifier;
    private final boolean export;
    private final boolean optional;
    private final List<FilterSpecification> importFilters = new ArrayList<FilterSpecification>();
    private final List<FilterSpecification> exportFilters = new ArrayList<FilterSpecification>();
    private final boolean importServices;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ModuleDependency [");
        if (this.identifier != null) {
            builder.append("identifier=").append(this.identifier).append(", ");
        }
        if (this.moduleLoader != null) {
            builder.append("moduleLoader=").append(this.moduleLoader).append(", ");
        }
        builder.append("export=").append(this.export).append(", optional=").append(this.optional).append(", importServices=").append(this.importServices).append("]");
        return builder.toString();
    }

    public ModuleDependency(ModuleLoader moduleLoader, ModuleIdentifier identifier, boolean optional, boolean export, boolean importServices) {
        this.identifier = identifier;
        this.optional = optional;
        this.export = export;
        this.moduleLoader = moduleLoader;
        this.importServices = importServices;
    }

    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isExport() {
        return this.export;
    }

    public void addImportFilter(PathFilter pathFilter, boolean include) {
        this.importFilters.add(new FilterSpecification(pathFilter, include));
    }

    public List<FilterSpecification> getImportFilters() {
        return this.importFilters;
    }

    public void addExportFilter(PathFilter pathFilter, boolean include) {
        this.exportFilters.add(new FilterSpecification(pathFilter, include));
    }

    public List<FilterSpecification> getExportFilters() {
        return this.exportFilters;
    }

    public boolean isImportServices() {
        return this.importServices;
    }
}

