/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.moduleservice;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.Services;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class ServiceModuleLoader
extends ModuleLoader
implements Service<ServiceModuleLoader> {
    public static final ServiceName MODULE_SPEC_SERVICE_PREFIX = ServiceName.of((String[])new String[]{"module", "spec", "service"});
    public static final ServiceName MODULE_SERVICE_PREFIX = ServiceName.of((String[])new String[]{"module", "service"});
    public static final String MODULE_PREFIX = "deployment.";
    private final ModuleLoader mainModuleLoader;
    private volatile ServiceContainer serviceContainer;

    public ServiceModuleLoader(ModuleLoader mainModuleLoader) {
        this.mainModuleLoader = mainModuleLoader;
    }

    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        if (identifier.getName().startsWith(MODULE_PREFIX)) {
            return super.preloadModule(identifier);
        }
        return ServiceModuleLoader.preloadModule((ModuleIdentifier)identifier, (ModuleLoader)this.mainModuleLoader);
    }

    protected ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
        ServiceController controller = this.serviceContainer.getService(ServiceModuleLoader.moduleSpecServiceName(identifier));
        if (controller == null) {
            throw new ModuleLoadException("Could not load module " + identifier + " as corresponding module spec service " + identifier + " was not found");
        }
        ModuleSpecLoadListener listener = new ModuleSpecLoadListener(identifier);
        controller.addListener((ServiceListener)listener);
        return listener.getModuleSpec();
    }

    public String toString() {
        return "Service Module Loader";
    }

    public synchronized void start(StartContext context) throws StartException {
        if (this.serviceContainer != null) {
            throw new IllegalStateException("ServiceModuleLoader already started");
        }
        this.serviceContainer = context.getController().getServiceContainer();
    }

    public synchronized void stop(StopContext context) {
        if (this.serviceContainer == null) {
            throw new IllegalStateException("ServiceModuleLoader already stopped");
        }
        this.serviceContainer = null;
    }

    public ServiceModuleLoader getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void relinkModule(Module module) throws ModuleLoadException {
        this.relink(module);
    }

    public static void addService(ServiceTarget serviceTarget, Bootstrap.Configuration configuration) {
        ServiceModuleLoader service = new ServiceModuleLoader(configuration.getModuleLoader());
        ServiceBuilder serviceBuilder = serviceTarget.addService(Services.JBOSS_SERVICE_MODULE_LOADER, (Service)service);
        serviceBuilder.install();
    }

    public static ServiceName moduleSpecServiceName(ModuleIdentifier identifier) {
        if (!identifier.getName().startsWith(MODULE_PREFIX)) {
            throw new IllegalArgumentException(identifier + " cannot be loaded from a ServiceModuleLoader as its name does not start with " + MODULE_PREFIX);
        }
        return MODULE_SPEC_SERVICE_PREFIX.append(new String[]{identifier.getName()}).append(new String[]{identifier.getSlot()});
    }

    public static ServiceName moduleServiceName(ModuleIdentifier identifier) {
        if (!identifier.getName().startsWith(MODULE_PREFIX)) {
            throw new IllegalArgumentException(identifier + " cannot be loaded from a ServiceModuleLoader as its name does not start with " + MODULE_PREFIX);
        }
        return MODULE_SERVICE_PREFIX.append(new String[]{identifier.getName()}).append(new String[]{identifier.getSlot()});
    }

    private class ModuleSpecLoadListener
    extends AbstractServiceListener<ModuleSpec> {
        private final CountDownLatch latch = new CountDownLatch(1);
        private final ModuleIdentifier identifier;
        private volatile StartException startException;
        private volatile ModuleSpec moduleSpec;

        private ModuleSpecLoadListener(ModuleIdentifier identifier) {
            this.identifier = identifier;
        }

        public void listenerAdded(ServiceController<? extends ModuleSpec> controller) {
            ServiceController.State state = controller.getState();
            if (state == ServiceController.State.UP || state == ServiceController.State.START_FAILED) {
                this.done(controller, controller.getStartException());
            }
        }

        public void serviceStarted(ServiceController<? extends ModuleSpec> controller) {
            this.done(controller, null);
        }

        public void serviceFailed(ServiceController<? extends ModuleSpec> controller, StartException reason) {
            this.done(controller, reason);
        }

        public void serviceStopping(ServiceController<? extends ModuleSpec> controller) {
            ModuleSpec moduleSpec = this.moduleSpec;
            try {
                Module module = ServiceModuleLoader.this.loadModule(moduleSpec.getModuleIdentifier());
                ServiceModuleLoader.this.unloadModuleLocal(module);
            }
            catch (ModuleLoadException moduleLoadException) {
                // empty catch block
            }
            controller.removeListener((ServiceListener)this);
        }

        private void done(ServiceController<? extends ModuleSpec> controller, StartException reason) {
            this.latch.countDown();
            this.startException = reason;
            if (this.startException == null) {
                this.moduleSpec = (ModuleSpec)controller.getValue();
            }
        }

        public ModuleSpec getModuleSpec() throws ModuleLoadException {
            if (this.moduleSpec != null) {
                return this.moduleSpec;
            }
            if (this.startException != null) {
                throw new ModuleLoadException(this.startException.getCause());
            }
            try {
                if (!this.latch.await(1000L, TimeUnit.MILLISECONDS)) {
                    throw new ModuleLoadException("Timeout waiting for module service: " + this.identifier);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.moduleSpec;
        }
    }
}

