/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.server.operations.SystemPropertyAddHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class SystemPropertyRemoveHandler
extends org.jboss.as.controller.operations.common.SystemPropertyRemoveHandler {
    public static final SystemPropertyRemoveHandler INSTANCE = new SystemPropertyRemoveHandler();
    private final ParameterValidator typeValidator = new StringLengthValidator(1);

    public static ModelNode getOperation(ModelNode address, String name) {
        ModelNode op = Util.getEmptyOperation((String)"remove-system-property", (ModelNode)address);
        op.get("name").set(name);
        return op;
    }

    protected SystemPropertyRemoveHandler() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode param = operation.get("name");
        this.typeValidator.validateParameter("name", param);
        ModelNode properties = context.getSubModel().get("system-properties");
        ModelNode toRemove = null;
        ModelNode newMap = new ModelNode().setEmptyObject();
        String name = param.asString();
        if (properties.isDefined()) {
            for (Property property : properties.asPropertyList()) {
                if (!name.equals(property.getName())) {
                    toRemove = newMap.get(property.getName()).set(property.getValue());
                    continue;
                }
                toRemove = property.getValue();
            }
        }
        if (toRemove != null) {
            properties.set(newMap);
            String value = toRemove.isDefined() ? toRemove.asString() : null;
            ModelNode compensating = SystemPropertyAddHandler.getOperation(operation.get("address"), name, value);
            return this.removeSystemProperty(name, context, resultHandler, compensating);
        }
        throw new OperationFailedException(new ModelNode().set("No property with " + name + "found"));
    }

    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getRemoveSystemPropertyOperation((Locale)locale);
    }

    protected OperationResult removeSystemProperty(final String name, OperationContext context, final ResultHandler resultHandler, ModelNode compensating) {
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    System.clearProperty(name);
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensating);
    }
}

