/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.SocketBindingAddHandler;
import org.jboss.as.controller.operations.validation.InetAddressValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.server.services.net.NetworkInterfaceBinding;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.as.server.services.net.SocketBinding;
import org.jboss.as.server.services.net.SocketBindingManager;
import org.jboss.as.server.services.net.SocketBindingService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class BindingAddHandler
extends SocketBindingAddHandler {
    public static final BindingAddHandler INSTANCE = new BindingAddHandler();
    private final ParametersValidator runtimeValidator = new ParametersValidator();

    private BindingAddHandler() {
        this.runtimeValidator.registerValidator("interface", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
        this.runtimeValidator.registerValidator("port", (ParameterValidator)new IntRangeValidator(0, 65535, false, false));
        this.runtimeValidator.registerValidator("fixed-port", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true, false));
        this.runtimeValidator.registerValidator("multicast-address", (ParameterValidator)new InetAddressValidator(true, false));
        this.runtimeValidator.registerValidator("multicast-port", (ParameterValidator)new IntRangeValidator(0, 65535, true, false));
    }

    protected OperationResult installSocketBinding(final String name, ModelNode operation, OperationContext context, final ResultHandler resultHandler, ModelNode compensatingOp) throws OperationFailedException {
        if (context.getRuntimeContext() != null) {
            final ModelNode resolvedOp = operation.resolve();
            this.runtimeValidator.validate(resolvedOp);
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    String intf = resolvedOp.get("interface").isDefined() ? resolvedOp.get("interface").asString() : null;
                    int port = resolvedOp.get("port").asInt();
                    boolean fixedPort = resolvedOp.get("fixed-port").asBoolean(false);
                    String mcastAddr = resolvedOp.get("multicast-address").isDefined() ? resolvedOp.get("multicast-address").asString() : null;
                    int mcastPort = resolvedOp.get("multicast-port").isDefined() ? resolvedOp.get("multicast-port").asInt() : 0;
                    try {
                        InetAddress mcastInet = mcastAddr == null ? null : InetAddress.getByName(mcastAddr);
                        SocketBindingService service = new SocketBindingService(name, port, fixedPort, mcastInet, mcastPort);
                        ServiceBuilder builder = serviceTarget.addService(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{name}), (Service)service);
                        if (intf != null) {
                            builder.addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{intf}), NetworkInterfaceBinding.class, service.getInterfaceBinding());
                        }
                        builder.addDependency(SocketBindingManager.SOCKET_BINDING_MANAGER, SocketBindingManager.class, service.getSocketBindings()).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
                        resultHandler.handleResultComplete();
                    }
                    catch (UnknownHostException e) {
                        throw new OperationFailedException(new ModelNode().set(e.getLocalizedMessage()));
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOp);
    }
}

