/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class ServerDependenciesProcessor
implements DeploymentUnitProcessor {
    private static ModuleIdentifier SUN_JDK = ModuleIdentifier.create((String)"sun.jdk");
    private static ModuleIdentifier JAVAX_API = ModuleIdentifier.create((String)"javax.api");
    private static ModuleIdentifier JBOSS_LOGGING = ModuleIdentifier.create((String)"org.jboss.logging");
    private static ModuleIdentifier JBOSS_VFS = ModuleIdentifier.create((String)"org.jboss.vfs");

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, SUN_JDK, false, false, true));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, JAVAX_API, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, JBOSS_LOGGING, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, JBOSS_VFS, false, false, false));
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }
}

