/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.SocketBindingAddHandler;
import org.jboss.as.controller.operations.validation.InetAddressValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.as.server.services.net.SocketBindingService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class BindingAddHandler
extends SocketBindingAddHandler {
    public static final BindingAddHandler INSTANCE = new BindingAddHandler();
    private final ParametersValidator runtimeValidator = new ParametersValidator();

    private BindingAddHandler() {
        this.runtimeValidator.registerValidator("interface", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
        this.runtimeValidator.registerValidator("port", (ParameterValidator)new IntRangeValidator(0, 65535, false, false));
        this.runtimeValidator.registerValidator("fixed-port", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true, false));
        this.runtimeValidator.registerValidator("multicast-address", (ParameterValidator)new InetAddressValidator(true, false));
        this.runtimeValidator.registerValidator("multicast-port", (ParameterValidator)new IntRangeValidator(0, 65535, true, false));
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode resolvedOp = operation.resolve();
        this.runtimeValidator.validate(resolvedOp);
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        try {
            newControllers.add(BindingAddHandler.installBindingService(context, resolvedOp, name));
        }
        catch (UnknownHostException e) {
            throw new OperationFailedException(new ModelNode().set(e.getLocalizedMessage()));
        }
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }

    public static ServiceController<SocketBinding> installBindingService(OperationContext context, ModelNode resolvedConfig, String name) throws UnknownHostException {
        ServiceTarget serviceTarget = context.getServiceTarget();
        String intf = resolvedConfig.get("interface").isDefined() ? resolvedConfig.get("interface").asString() : null;
        int port = resolvedConfig.get("port").asInt();
        boolean fixedPort = resolvedConfig.get("fixed-port").asBoolean(false);
        String mcastAddr = resolvedConfig.get("multicast-address").isDefined() ? resolvedConfig.get("multicast-address").asString() : null;
        int mcastPort = resolvedConfig.get("multicast-port").isDefined() ? resolvedConfig.get("multicast-port").asInt() : 0;
        InetAddress mcastInet = mcastAddr == null ? null : InetAddress.getByName(mcastAddr);
        SocketBindingService service = new SocketBindingService(name, port, fixedPort, mcastInet, mcastPort);
        ServiceBuilder builder = serviceTarget.addService(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{name}), (Service)service);
        if (intf != null) {
            builder.addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{intf}), NetworkInterfaceBinding.class, service.getInterfaceBinding());
        }
        return builder.addDependency(SocketBindingManager.SOCKET_BINDING_MANAGER, SocketBindingManager.class, service.getSocketBindings()).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }
}

