/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.StandaloneXml;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.TransientConfigurationPersister;
import org.jboss.as.embedded.ServerStartException;
import org.jboss.as.embedded.StandaloneServer;
import org.jboss.as.protocol.old.StreamUtils;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.Main;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.client.ModelControllerServerDeploymentManager;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.threads.AsyncFuture;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class EmbeddedStandAloneServerFactory {
    public static final String JBOSS_EMBEDDED_ROOT = "jboss.embedded.root";

    private EmbeddedStandAloneServerFactory() {
    }

    public static StandaloneServer create(File jbossHomeDir, final ModuleLoader moduleLoader, final Properties systemProps, final Map<String, String> systemEnv) {
        EmbeddedStandAloneServerFactory.setupCleanDirectories(jbossHomeDir, systemProps);
        StandaloneServer standaloneServer = new StandaloneServer(){
            private ServiceContainer serviceContainer;
            private ServerDeploymentManager serverDeploymentManager;
            private Context context;
            private ModelControllerClient modelControllerClient;

            public void deploy(File file) throws IOException, ExecutionException, InterruptedException {
                this.execute(this.serverDeploymentManager.newDeploymentPlan().add(file.getName(), VFSUtils.createJarFileInputStream((VirtualFile)VFS.getChild((URI)file.toURI()))).andDeploy().build());
            }

            private ServerDeploymentPlanResult execute(DeploymentPlan deploymentPlan) throws ExecutionException, InterruptedException {
                return (ServerDeploymentPlanResult)this.serverDeploymentManager.execute(deploymentPlan).get();
            }

            public Context getContext() {
                return (Context)EmbeddedStandAloneServerFactory.ifSet(this.context, "Server has not been started");
            }

            public ModelControllerClient getModelControllerClient() {
                return this.modelControllerClient;
            }

            public void start() throws ServerStartException {
                try {
                    ServerEnvironment serverEnviromment = Main.determineEnvironment(new String[0], systemProps, systemEnv, ServerEnvironment.LaunchType.EMBEDDED);
                    Bootstrap bootstrap = Bootstrap.Factory.newInstance();
                    Bootstrap.Configuration configuration = new Bootstrap.Configuration();
                    QName rootElement = new QName(Namespace.CURRENT.getUriString(), "server");
                    StandaloneXml parser = new StandaloneXml(Module.getBootModuleLoader());
                    configuration.setConfigurationPersister((ExtensibleConfigurationPersister)new TransientConfigurationPersister(serverEnviromment.getServerConfigurationFile(), rootElement, (XMLElementReader)parser, (XMLElementWriter)parser));
                    configuration.setServerEnvironment(serverEnviromment);
                    configuration.setModuleLoader(moduleLoader);
                    AsyncFuture<ServiceContainer> future = bootstrap.startup(configuration, Collections.<ServiceActivator>emptyList());
                    this.serviceContainer = (ServiceContainer)future.get();
                    ServiceController controllerService = this.serviceContainer.getRequiredService(Services.JBOSS_SERVER_CONTROLLER);
                    ModelController controller = (ModelController)controllerService.getValue();
                    this.serverDeploymentManager = new ModelControllerServerDeploymentManager(controller);
                    this.modelControllerClient = controller.createClient((Executor)Executors.newCachedThreadPool());
                    this.context = new InitialContext();
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (Exception ex) {
                    throw new ServerStartException((Throwable)ex);
                }
            }

            public void stop() {
                if (this.context != null) {
                    try {
                        this.context.close();
                        this.context = null;
                    }
                    catch (NamingException e) {
                        e.printStackTrace();
                    }
                }
                this.serverDeploymentManager = null;
                if (this.serviceContainer != null) {
                    try {
                        this.serviceContainer.shutdown();
                        this.serviceContainer.awaitTermination();
                    }
                    catch (RuntimeException rte) {
                        throw rte;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }

            public void undeploy(File file) throws ExecutionException, InterruptedException {
                this.execute(this.serverDeploymentManager.newDeploymentPlan().undeploy(file.getName()).andRemoveUndeployed().build());
            }
        };
        return standaloneServer;
    }

    private static <T> T ifSet(T value, String message) {
        if (value == null) {
            throw new IllegalStateException(message);
        }
        return value;
    }

    public static void setupCleanDirectories(Properties props) {
        File jbossHomeDir = new File(props.getProperty("jboss.home.dir"));
        EmbeddedStandAloneServerFactory.setupCleanDirectories(jbossHomeDir, props);
    }

    static void setupCleanDirectories(File jbossHomeDir, Properties props) {
        File tempRoot = EmbeddedStandAloneServerFactory.getTempRoot(props);
        if (tempRoot == null) {
            return;
        }
        File originalConfigDir = EmbeddedStandAloneServerFactory.getFileUnderAsRoot(jbossHomeDir, props, "jboss.server.config.dir", "configuration", true);
        File originalDataDir = EmbeddedStandAloneServerFactory.getFileUnderAsRoot(jbossHomeDir, props, "jboss.server.data.dir", "data", false);
        File configDir = new File(tempRoot, "config");
        configDir.mkdir();
        File dataDir = new File(tempRoot, "data");
        dataDir.mkdir();
        File deploymentsDir = new File(tempRoot, "deployments");
        deploymentsDir.mkdir();
        EmbeddedStandAloneServerFactory.copyDirectory(originalConfigDir, configDir);
        if (originalDataDir.exists()) {
            EmbeddedStandAloneServerFactory.copyDirectory(originalDataDir, dataDir);
        }
        props.put("jboss.server.base.dir", tempRoot.getAbsolutePath());
        props.put("jboss.server.config.dir", configDir.getAbsolutePath());
        props.put("jboss.server.data.dir", dataDir.getAbsolutePath());
    }

    private static File getFileUnderAsRoot(File jbossHomeDir, Properties props, String propName, String relativeLocation, boolean mustExist) {
        String prop = props.getProperty(propName, null);
        if (prop == null) {
            prop = props.getProperty("jboss.server.base.dir", null);
            if (prop == null) {
                File dir = new File(jbossHomeDir, "standalone/" + relativeLocation);
                if (!(!mustExist || dir.exists() && dir.isDirectory())) {
                    throw new IllegalArgumentException("No directory called 'standalone/' " + relativeLocation + " under " + jbossHomeDir.getAbsolutePath());
                }
                return dir;
            }
            File server = new File(prop);
            EmbeddedStandAloneServerFactory.validateDirectory("jboss.server.base.dir", server);
            return new File(server, relativeLocation);
        }
        File dir = new File(prop);
        EmbeddedStandAloneServerFactory.validateDirectory("jboss.server.config.dir", dir);
        return dir;
    }

    private static File getTempRoot(Properties props) {
        String tempRoot = props.getProperty(JBOSS_EMBEDDED_ROOT, null);
        if (tempRoot == null) {
            return null;
        }
        File root = new File(tempRoot);
        if (!root.exists()) {
            root.mkdirs();
        }
        EmbeddedStandAloneServerFactory.validateDirectory("jboss.test.clean.root", root);
        root = new File(root, "configs");
        root.mkdir();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        root = new File(root, format.format(new Date()));
        root.mkdir();
        return root;
    }

    private static void validateDirectory(String property, File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("-D" + property + "=" + file.getAbsolutePath() + " does not exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("-D" + property + "=" + file.getAbsolutePath() + " is not a directory");
        }
    }

    private static void copyDirectory(File src, File dest) {
        for (String current : src.list()) {
            File srcFile = new File(src, current);
            File destFile = new File(dest, current);
            if (srcFile.isDirectory()) {
                destFile.mkdir();
                EmbeddedStandAloneServerFactory.copyDirectory(srcFile, destFile);
                continue;
            }
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(srcFile));
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFile));
                try {
                    int i;
                    while ((i = ((InputStream)in).read()) != -1) {
                        ((OutputStream)out).write(i);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Error copying " + srcFile.getAbsolutePath() + " to " + destFile.getAbsolutePath(), e);
                }
                finally {
                    StreamUtils.safeClose((Closeable)in);
                    StreamUtils.safeClose((Closeable)out);
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

