/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.common.SocketBindingGroupDescription;
import org.jboss.as.controller.operations.common.AbstractSocketBindingGroupAddHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.as.server.services.net.SocketBindingManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

public class BindingGroupAddHandler
extends AbstractSocketBindingGroupAddHandler {
    private static final ParametersValidator VALIDATOR = new ParametersValidator();
    public static final BindingGroupAddHandler INSTANCE;
    private final ParametersValidator runtimeValidator = new ParametersValidator();

    public static final ModelNode getOperation(ModelNode address, ModelNode model) {
        ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)address);
        op.get("default-interface").set(model.get("default-interface"));
        op.get("port-offset").set(model.get("port-offset"));
        return op;
    }

    private BindingGroupAddHandler() {
        super(VALIDATOR);
        this.runtimeValidator.registerValidator("default-interface", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, false));
        this.runtimeValidator.registerValidator("port-offset", (ParameterValidator)new IntRangeValidator(0, 65535, true, false));
    }

    public ModelNode getModelDescription(Locale locale) {
        return SocketBindingGroupDescription.getServerSocketBindingGroupAddOperation((Locale)locale);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        super.populateModel(operation, model);
        ModelNode offset = operation.get("port-offset");
        if (!offset.isDefined()) {
            offset.set(0);
        }
        model.get("port-offset").set(offset);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode resolvedOp = operation.resolve();
        this.runtimeValidator.validate(resolvedOp);
        int portOffset = resolvedOp.get("port-offset").isDefined() ? resolvedOp.get("port-offset").asInt() : 0;
        String defaultInterface = resolvedOp.require("default-interface").asString();
        SocketBindingManagerService service = new SocketBindingManagerService(portOffset);
        ServiceTarget serviceTarget = context.getServiceTarget();
        newControllers.add(serviceTarget.addService(SocketBindingManager.SOCKET_BINDING_MANAGER, (Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{defaultInterface}), NetworkInterfaceBinding.class, service.getDefaultInterfaceBinding()).addListener((ServiceListener)verificationHandler).install());
    }

    static {
        VALIDATOR.registerValidator("default-interface", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true));
        VALIDATOR.registerValidator("port-offset", (ParameterValidator)new IntRangeValidator(0, 65535, true, true));
        INSTANCE = new BindingGroupAddHandler();
    }
}

