/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.annotation;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.moduleservice.ModuleIndexBuilder;
import org.jboss.jandex.Index;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

public class CompositeIndexProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Boolean computeCompositeIndex = deploymentUnit.getAttachment(Attachments.COMPUTE_COMPOSITE_ANNOTATION_INDEX);
        if (computeCompositeIndex != null && !computeCompositeIndex.booleanValue()) {
            return;
        }
        List<ModuleIdentifier> additionalModuleIndexes = deploymentUnit.getAttachmentList(Attachments.ADDITIONAL_ANNOTATION_INDEXES);
        ArrayList<Index> indexes = new ArrayList<Index>();
        for (ModuleIdentifier moduleIdentifier : additionalModuleIndexes) {
            try {
                Module module = Module.getBootModuleLoader().loadModule(moduleIdentifier);
                CompositeIndex additionalIndex = ModuleIndexBuilder.buildCompositeIndex(module);
                if (additionalIndex != null) {
                    indexes.addAll(additionalIndex.indexes);
                    continue;
                }
                ServerLogger.DEPLOYMENT_LOGGER.noCompositeIndex(module.getIdentifier(), "META-INF/jandex.idx");
            }
            catch (ModuleLoadException e) {
                throw new DeploymentUnitProcessingException(e);
            }
        }
        ArrayList<? extends ResourceRoot> allResourceRoots = new ArrayList<ResourceRoot>();
        List<ResourceRoot> resourceRoots = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
        for (ResourceRoot resourceRoot : resourceRoots) {
            if (SubDeploymentMarker.isSubDeployment(resourceRoot) || !ModuleRootMarker.isModuleRoot(resourceRoot)) continue;
            allResourceRoots.add(resourceRoot);
        }
        allResourceRoots.addAll(this.handleClassPathItems(deploymentUnit));
        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (ModuleRootMarker.isModuleRoot(deploymentRoot)) {
            allResourceRoots.add(deploymentRoot);
        }
        for (ResourceRoot resourceRoot : allResourceRoots) {
            Index index = resourceRoot.getAttachment(Attachments.ANNOTATION_INDEX);
            if (index == null) continue;
            indexes.add(index);
        }
        deploymentUnit.putAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX, new CompositeIndex(indexes));
    }

    private Collection<? extends ResourceRoot> handleClassPathItems(DeploymentUnit deploymentUnit) {
        HashSet<ResourceRoot> additionalRoots = new HashSet<ResourceRoot>();
        ArrayDeque<ResourceRoot> toProcess = new ArrayDeque<ResourceRoot>();
        List<ResourceRoot> resourceRoots = DeploymentUtils.allResourceRoots(deploymentUnit);
        toProcess.addAll(resourceRoots);
        HashSet<ResourceRoot> processed = new HashSet<ResourceRoot>(resourceRoots);
        while (!toProcess.isEmpty()) {
            ResourceRoot root = (ResourceRoot)toProcess.pop();
            List<ResourceRoot> classPathRoots = root.getAttachmentList(Attachments.CLASS_PATH_RESOURCE_ROOTS);
            for (ResourceRoot cpRoot : classPathRoots) {
                if (processed.contains(cpRoot)) continue;
                additionalRoots.add(cpRoot);
                toProcess.add(cpRoot);
                processed.add(cpRoot);
            }
        }
        return additionalRoots;
    }

    @Override
    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
    }
}

