/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.SecurityActions;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.ServerTask;
import org.jboss.as.server.parsing.StandaloneXml;
import org.jboss.as.version.ProductConfig;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.threads.AsyncFuture;

public final class ServerStartTask
implements ServerTask,
Serializable,
ObjectInputValidation {
    private static final long serialVersionUID = -1037124182656400874L;
    private final String serverName;
    private final int portOffset;
    private final String hostControllerName;
    private final String home;
    private final List<ServiceActivator> startServices;
    private final List<ModelNode> updates;
    private final Properties properties = new Properties();

    public ServerStartTask(String hostControllerName, String serverName, int portOffset, List<ServiceActivator> startServices, List<ModelNode> updates, Map<String, String> launchProperties) {
        assert (serverName != null && serverName.length() > 0) : "Server name \"" + serverName + "\" is invalid; cannot be null or blank";
        assert (hostControllerName != null && hostControllerName.length() > 0) : "Host Controller name \"" + hostControllerName + "\" is invalid; cannot be null or blank";
        this.serverName = serverName;
        this.portOffset = portOffset;
        this.startServices = startServices;
        this.updates = updates;
        this.hostControllerName = hostControllerName;
        this.home = SecurityActions.getSystemProperty("jboss.home.dir");
        String serverBaseDir = SecurityActions.getSystemProperty("jboss.domain.servers.dir") + File.separatorChar + serverName;
        this.properties.setProperty("jboss.server.name", serverName);
        this.properties.setProperty("jboss.home.dir", this.home);
        this.properties.setProperty("jboss.server.base.dir", serverBaseDir);
        this.properties.setProperty("jboss.controller.temp.dir", SecurityActions.getSystemProperty("jboss.domain.temp.dir"));
        this.properties.setProperty("jboss.domain.base.dir", SecurityActions.getSystemProperty("jboss.domain.base.dir"));
        this.properties.setProperty("jboss.domain.config.dir", SecurityActions.getSystemProperty("jboss.domain.config.dir"));
        ServerStartTask.setPropertyIfFound(launchProperties, "java.ext.dirs", this.properties);
        ServerStartTask.setPropertyIfFound(launchProperties, "jboss.qualified.host.name", this.properties);
        ServerStartTask.setPropertyIfFound(launchProperties, "jboss.host.name", this.properties);
        ServerStartTask.setPropertyIfFound(launchProperties, "jboss.node.name", this.properties);
        String deprecated = "jboss.modules.dir";
        ServerStartTask.setPropertyIfFound(launchProperties, deprecated, this.properties);
        ServerStartTask.setPropertyIfFound(launchProperties, "jboss.bundles.dir", this.properties);
        ServerStartTask.setPropertyIfFound(launchProperties, "jboss.server.data.dir", this.properties);
        ServerStartTask.setPropertyIfFound(launchProperties, "jboss.server.content.dir", this.properties);
        ServerStartTask.setPropertyIfFound(launchProperties, "jboss.server.log.dir", this.properties);
        ServerStartTask.setPropertyIfFound(launchProperties, "jboss.server.temp.dir", this.properties);
    }

    @Override
    public AsyncFuture<ServiceContainer> run(List<ServiceActivator> runServices) {
        Bootstrap bootstrap = Bootstrap.Factory.newInstance();
        ProductConfig productConfig = new ProductConfig(Module.getBootModuleLoader(), this.home);
        ServerEnvironment providedEnvironment = new ServerEnvironment(this.hostControllerName, this.properties, SecurityActions.getSystemEnvironment(), null, ServerEnvironment.LaunchType.DOMAIN, RunningMode.NORMAL, productConfig);
        final Bootstrap.Configuration configuration = new Bootstrap.Configuration(providedEnvironment);
        final ExtensionRegistry extensionRegistry = configuration.getExtensionRegistry();
        Bootstrap.ConfigurationPersisterFactory configurationPersisterFactory = new Bootstrap.ConfigurationPersisterFactory(){

            @Override
            public ExtensibleConfigurationPersister createConfigurationPersister(ServerEnvironment serverEnvironment, ExecutorService executorService) {
                AbstractConfigurationPersister persister = new AbstractConfigurationPersister(new StandaloneXml(configuration.getModuleLoader(), executorService, extensionRegistry)){
                    private final ConfigurationPersister.PersistenceResource pr;
                    {
                        this.pr = new ConfigurationPersister.PersistenceResource(){

                            public void commit() {
                            }

                            public void rollback() {
                            }
                        };
                    }

                    public ConfigurationPersister.PersistenceResource store(ModelNode model, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
                        return this.pr;
                    }

                    public List<ModelNode> load() throws ConfigurationPersistenceException {
                        return ServerStartTask.this.updates;
                    }
                };
                extensionRegistry.setWriterRegistry((SubsystemXmlWriterRegistry)persister);
                return persister;
            }
        };
        configuration.setConfigurationPersisterFactory(configurationPersisterFactory);
        return bootstrap.bootstrap(configuration, this.startServices);
    }

    @Override
    public void validateObject() throws InvalidObjectException {
        if (this.serverName == null) {
            throw ServerMessages.MESSAGES.invalidObject("serverName");
        }
        if (this.hostControllerName == null) {
            throw ServerMessages.MESSAGES.invalidObject("hostControllerName");
        }
        if (this.portOffset < 0) {
            throw ServerMessages.MESSAGES.invalidPortOffset();
        }
        if (this.updates == null) {
            throw ServerMessages.MESSAGES.invalidObject("updates");
        }
        if (this.startServices == null) {
            throw ServerMessages.MESSAGES.invalidObject("startServices");
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        ois.registerValidation(this, 100);
    }

    static void setPropertyIfFound(Map<String, String> launchProperties, String key, Properties properties) {
        if (launchProperties.containsKey(key)) {
            properties.setProperty(key, launchProperties.get(key));
        }
    }
}

