/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.ThreadsSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class BoundedQueueThreadPoolRemove
implements ModelRemoveOperationHandler,
DescriptionProvider {
    static final BoundedQueueThreadPoolRemove INSTANCE = new BoundedQueueThreadPoolRemove();

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        ModelNode opAddr = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        ModelNode model = context.getSubModel();
        ModelNode compensating = Util.getEmptyOperation((String)"add", (ModelNode)opAddr);
        if (model.hasDefined("thread-factory")) {
            compensating.get("thread-factory").set(model.get("thread-factory"));
        }
        if (model.hasDefined("properties")) {
            compensating.get("properties").set(model.get("properties"));
        }
        if (model.hasDefined("core-threads")) {
            compensating.get("core-threads").set(model.get("core-threads"));
        }
        if (model.hasDefined("max-threads")) {
            compensating.get("max-threads").set(model.get("max-threads"));
        }
        if (model.hasDefined("keepalive-time")) {
            compensating.get("keepalive-time").set(model.get("keepalive-time"));
        }
        if (model.hasDefined("queue-length")) {
            compensating.get("queue-length").set(model.get("queue-length"));
        }
        if (model.hasDefined("blocking")) {
            compensating.get("blocking").set(model.get("blocking"));
        }
        if (model.hasDefined("allow-core-timeout")) {
            compensating.get("allow-core-timeout").set(model.get("allow-core-timeout"));
        }
        if (model.hasDefined("handoff-executor")) {
            compensating.get("handoff-executor").set(model.get("handoff-executor"));
        }
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry().getService(ThreadsServices.threadFactoryName(name));
                    if (controller != null) {
                        controller.setMode(ServiceController.Mode.REMOVE);
                    }
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensating);
    }

    public ModelNode getModelDescription(Locale locale) {
        return ThreadsSubsystemProviders.REMOVE_BOUNDED_QUEUE_THREAD_POOL_DESC.getModelDescription(locale);
    }
}

