/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;

public final class ScaledCount
implements Serializable {
    private static final long serialVersionUID = 50591622989801087L;
    private final BigDecimal count;
    private final BigDecimal perCpu;

    public ScaledCount(BigDecimal count, BigDecimal perCpu) {
        if (count.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException("Count must be greater than or equal to zero");
        }
        if (perCpu.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException("Per-cpu must be greater than or equal to zero");
        }
        this.count = count;
        this.perCpu = perCpu;
    }

    public BigDecimal getCount() {
        return this.count;
    }

    public BigDecimal getPerCpu() {
        return this.perCpu;
    }

    public int getScaledCount() {
        return this.count.add(this.perCpu.multiply(BigDecimal.valueOf(Runtime.getRuntime().availableProcessors()), MathContext.DECIMAL64), MathContext.DECIMAL64).round(MathContext.DECIMAL64).intValueExact();
    }

    public boolean equals(Object obj) {
        return obj instanceof ScaledCount && this.equals((ScaledCount)obj);
    }

    public boolean equals(ScaledCount obj) {
        return obj != null && obj.count.equals(this.count) && obj.perCpu.equals(this.perCpu);
    }

    public int hashCode() {
        return this.count.hashCode() * 31 + this.perCpu.hashCode();
    }
}

