/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.threads.ThreadFactoryService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.ThreadsSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;

public class ThreadFactoryAdd
implements ModelAddOperationHandler,
DescriptionProvider {
    static final ThreadFactoryAdd INSTANCE = new ThreadFactoryAdd();

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        int priority;
        ModelNode opAddr = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        final String groupName = operation.hasDefined("group-name") ? operation.get("group-name").asString() : null;
        final String threadNamePattern = operation.hasDefined("thread-name-pattern") ? operation.get("thread-name-pattern").asString() : null;
        int n = priority = operation.hasDefined("priority") ? operation.get("priority").asInt() : -1;
        if (priority != -1 && priority < 0 || priority > 10) {
            throw new IllegalArgumentException("priority is out of range " + priority);
        }
        ModelNode properties = operation.hasDefined("properties") ? operation.get("properties") : null;
        ModelNode model = context.getSubModel();
        model.get("name").set(name);
        if (groupName != null) {
            model.get("group-name").set(groupName);
        }
        if (threadNamePattern != null) {
            model.get("thread-name-pattern").set(threadNamePattern);
        }
        if (priority >= 0) {
            model.get("priority").set(priority);
        }
        if (properties != null) {
            model.get("properties").set(properties);
        }
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget target = context.getServiceTarget();
                    ThreadFactoryService service = new ThreadFactoryService();
                    service.setNamePattern(threadNamePattern);
                    service.setPriority(priority);
                    service.setThreadGroupName(groupName);
                    try {
                        target.addService(ThreadsServices.threadFactoryName(name), (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).install();
                        resultHandler.handleResultComplete();
                    }
                    catch (ServiceRegistryException e) {
                        throw new OperationFailedException(new ModelNode().set(e.getMessage()));
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        ModelNode compensating = Util.getResourceRemoveOperation((ModelNode)opAddr);
        return new BasicOperationResult(compensating);
    }

    public ModelNode getModelDescription(Locale locale) {
        return ThreadsSubsystemProviders.ADD_THREAD_FACTORY_DESC.getModelDescription(locale);
    }
}

