/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.ThreadsSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class UnboundedQueueThreadPoolRemove
implements ModelRemoveOperationHandler,
DescriptionProvider {
    static final UnboundedQueueThreadPoolRemove INSTANCE = new UnboundedQueueThreadPoolRemove();

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        ModelNode opAddr = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry().getService(ThreadsServices.threadFactoryName(name));
                    if (controller != null) {
                        controller.setMode(ServiceController.Mode.REMOVE);
                    }
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        ModelNode model = context.getSubModel();
        ModelNode compensating = Util.getEmptyOperation((String)"add", (ModelNode)opAddr);
        if (model.hasDefined("thread-factory")) {
            compensating.get("thread-factory").set(model.get("thread-factory"));
        }
        if (model.hasDefined("properties")) {
            compensating.get("properties").set(model.get("properties"));
        }
        if (model.hasDefined("max-threads")) {
            compensating.get("max-threads").set(model.get("max-threads"));
        }
        if (model.hasDefined("keepalive-time")) {
            compensating.get("keepalive-time").set(model.get("keepalive-time"));
        }
        return new BasicOperationResult(compensating);
    }

    public ModelNode getModelDescription(Locale locale) {
        return ThreadsSubsystemProviders.REMOVE_UNBOUNDED_QUEUE_THREAD_POOL_DESC.getModelDescription(locale);
    }
}

