/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn;

import com.arjuna.ats.arjuna.common.RecoveryEnvironmentBean;
import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.internal.arjuna.recovery.AtomicActionRecoveryModule;
import com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionStatusManagerScanner;
import com.arjuna.ats.internal.jta.recovery.jts.XARecoveryModule;
import com.arjuna.ats.internal.jts.orbspecific.recovery.RecoveryEnablement;
import com.arjuna.ats.internal.jts.recovery.contact.ExpiredContactScanner;
import com.arjuna.ats.internal.jts.recovery.transactions.ExpiredServerScanner;
import com.arjuna.ats.internal.jts.recovery.transactions.ExpiredToplevelScanner;
import com.arjuna.ats.internal.jts.recovery.transactions.ServerTransactionRecoveryModule;
import com.arjuna.ats.internal.jts.recovery.transactions.TopLevelTransactionRecoveryModule;
import com.arjuna.ats.internal.txoj.recovery.TORecoveryModule;
import com.arjuna.ats.jbossatx.jta.RecoveryManagerService;
import java.util.ArrayList;
import java.util.Collections;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.txn.TransactionMessages;
import org.jboss.as.txn.TxnServices;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.omg.CORBA.ORB;

public class ArjunaRecoveryManagerService
implements Service<RecoveryManagerService> {
    public static final ServiceName SERVICE_NAME = TxnServices.JBOSS_TXN_ARJUNA_RECOVERY_MANAGER;
    private final InjectedValue<ORB> orbInjector = new InjectedValue();
    private final InjectedValue<SocketBinding> recoveryBindingInjector = new InjectedValue();
    private final InjectedValue<SocketBinding> statusBindingInjector = new InjectedValue();
    private RecoveryManagerService recoveryManagerService;
    private boolean recoveryListener;

    ArjunaRecoveryManagerService(boolean recoveryListener) {
        this.recoveryListener = recoveryListener;
    }

    public synchronized void start(StartContext context) throws StartException {
        ORB orb = (ORB)this.orbInjector.getValue();
        RecoveryEnvironmentBean recoveryEnvironmentBean = recoveryPropertyManager.getRecoveryEnvironmentBean();
        SocketBinding recoveryBinding = (SocketBinding)this.recoveryBindingInjector.getValue();
        recoveryEnvironmentBean.setRecoveryInetAddress(recoveryBinding.getSocketAddress().getAddress());
        recoveryEnvironmentBean.setRecoveryPort(recoveryBinding.getSocketAddress().getPort());
        SocketBinding statusBinding = (SocketBinding)this.statusBindingInjector.getValue();
        recoveryEnvironmentBean.setTransactionStatusManagerInetAddress(statusBinding.getSocketAddress().getAddress());
        recoveryEnvironmentBean.setTransactionStatusManagerPort(statusBinding.getSocketAddress().getPort());
        recoveryEnvironmentBean.setRecoveryListener(this.recoveryListener);
        ArrayList<String> recoveryExtensions = new ArrayList<String>();
        recoveryExtensions.add(AtomicActionRecoveryModule.class.getName());
        recoveryExtensions.add(TORecoveryModule.class.getName());
        ArrayList<String> expiryScanners = new ArrayList<String>();
        expiryScanners.add(ExpiredTransactionStatusManagerScanner.class.getName());
        if (orb == null) {
            recoveryExtensions.add(com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule.class.getName());
            recoveryEnvironmentBean.setRecoveryModuleClassNames(recoveryExtensions);
            recoveryEnvironmentBean.setExpiryScannerClassNames(expiryScanners);
            recoveryEnvironmentBean.setRecoveryActivators(null);
            RecoveryManagerService recoveryManagerService = new RecoveryManagerService();
            try {
                recoveryManagerService.create();
            }
            catch (Exception e) {
                throw TransactionMessages.MESSAGES.managerStartFailure(e, "Recovery");
            }
            recoveryManagerService.start();
            this.recoveryManagerService = recoveryManagerService;
        } else {
            recoveryExtensions.add(TopLevelTransactionRecoveryModule.class.getName());
            recoveryExtensions.add(ServerTransactionRecoveryModule.class.getName());
            recoveryExtensions.add(XARecoveryModule.class.getName());
            expiryScanners.add(ExpiredContactScanner.class.getName());
            expiryScanners.add(ExpiredToplevelScanner.class.getName());
            expiryScanners.add(ExpiredServerScanner.class.getName());
            recoveryEnvironmentBean.setRecoveryModuleClassNames(recoveryExtensions);
            recoveryEnvironmentBean.setExpiryScannerClassNames(expiryScanners);
            recoveryEnvironmentBean.setRecoveryActivatorClassNames(Collections.singletonList(RecoveryEnablement.class.getName()));
            try {
                com.arjuna.ats.jbossatx.jts.RecoveryManagerService recoveryManagerService = new com.arjuna.ats.jbossatx.jts.RecoveryManagerService(orb);
                recoveryManagerService.create();
                recoveryManagerService.start();
                this.recoveryManagerService = recoveryManagerService;
            }
            catch (Exception e) {
                throw TransactionMessages.MESSAGES.managerStartFailure(e, "Recovery");
            }
        }
    }

    public synchronized void stop(StopContext context) {
        try {
            this.recoveryManagerService.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.recoveryManagerService.destroy();
        this.recoveryManagerService = null;
    }

    public synchronized RecoveryManagerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this.recoveryManagerService;
    }

    Injector<ORB> getOrbInjector() {
        return this.orbInjector;
    }

    Injector<SocketBinding> getRecoveryBindingInjector() {
        return this.recoveryBindingInjector;
    }

    Injector<SocketBinding> getStatusBindingInjector() {
        return this.statusBindingInjector;
    }
}

