/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.spec.MimeMappingMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.ServletsMetaData;
import org.jboss.metadata.web.spec.SessionConfigMetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.metadata.web.spec.WelcomeFileListMetaData;

class SharedWebMetaDataBuilder {
    static final List<String> welcomeFiles = Arrays.asList("index.html", "index.htm", "index.jsp");
    static final List<MimeMappingMetaData> mimeMappings = new ArrayList<MimeMappingMetaData>();
    private final ModelNode containerConfig;

    SharedWebMetaDataBuilder(ModelNode containerConfig) {
        this.containerConfig = containerConfig;
        this.init();
    }

    private void init() {
        if (this.containerConfig.has("mime-mapping")) {
            for (Property mapping : this.containerConfig.get("mime-mapping").asPropertyList()) {
                mimeMappings.add(SharedWebMetaDataBuilder.createMimeMapping(mapping.getName(), mapping.getValue().asString()));
            }
        }
        if (this.containerConfig.has("welcome-file")) {
            for (ModelNode file : this.containerConfig.get("welcome-file").asList()) {
                welcomeFiles.add(file.asString());
            }
        }
    }

    WebMetaData create() {
        WebMetaData metadata = new WebMetaData();
        metadata.setServlets(new ServletsMetaData());
        this.enableStaticResouces(metadata);
        this.enableJsp(metadata);
        SessionConfigMetaData sessionConfig = new SessionConfigMetaData();
        sessionConfig.setSessionTimeout(30);
        metadata.setSessionConfig(sessionConfig);
        metadata.setMimeMappings(Collections.unmodifiableList(mimeMappings));
        metadata.setWelcomeFileList(new WelcomeFileListMetaData());
        metadata.getWelcomeFileList().setWelcomeFiles(Collections.unmodifiableList(welcomeFiles));
        return metadata;
    }

    void enableStaticResouces(WebMetaData metadata) {
        ModelNode resourcesConfig = this.containerConfig.get("static-resources");
        if (resourcesConfig.has("disabled") && resourcesConfig.get("disabled").asBoolean()) {
            return;
        }
        ServletMetaData servlet = new ServletMetaData();
        servlet.setName("DefaultServlet");
        servlet.setLoadOnStartup("1");
        if (resourcesConfig.has("webdav") && resourcesConfig.get("webdav").asBoolean()) {
            servlet.setServletClass("org.apache.catalina.servlets.WebdavServlet");
        } else {
            servlet.setServletClass("org.apache.catalina.servlets.DefaultServlet");
        }
        ArrayList<ParamValueMetaData> initParams = new ArrayList<ParamValueMetaData>();
        if (resourcesConfig.has("listings")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("listings", resourcesConfig.get("listings").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("listings", "false"));
        }
        if (resourcesConfig.has("read-only")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("readonly", resourcesConfig.get("read-only").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("readonly", "true"));
        }
        if (resourcesConfig.has("sendfile")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("sendfile", resourcesConfig.get("sendfile").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("sendfile", "49152"));
        }
        if (resourcesConfig.has("file-encoding")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("file-encoding", resourcesConfig.get("file-encoding").asString()));
        }
        if (resourcesConfig.has("secret")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("secret", resourcesConfig.get("secret").asString()));
        }
        if (resourcesConfig.has("max-depth")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("max-depth", resourcesConfig.get("max-depth").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("max-depth", "3"));
        }
        servlet.setInitParam(initParams);
        metadata.getServlets().add((MappableMetaData)servlet);
        SharedWebMetaDataBuilder.addServletMapping("DefaultServlet", metadata, "/");
    }

    void enableJsp(WebMetaData metadata) {
        ModelNode config = this.containerConfig.get("jsp-configuration");
        if (config.get("disabled").asBoolean(false)) {
            return;
        }
        ServletMetaData servlet = new ServletMetaData();
        servlet.setName("jsp");
        servlet.setLoadOnStartup("3");
        servlet.setServletClass("org.apache.jasper.servlet.JspServlet");
        ArrayList<ParamValueMetaData> initParams = new ArrayList<ParamValueMetaData>();
        if (config.has("development")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("development", config.get("development").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("development", "false"));
        }
        if (config.has("keep-generated")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("keepgenerated", config.get("keep-generated").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("keepgenerated", "true"));
        }
        if (config.has("trim-spaces")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("trimSpaces", config.get("trim-spaces").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("trimSpaces", "false"));
        }
        if (config.has("tag-pooling")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("enablePooling", config.get("tag-pooling").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("enablePooling", "true"));
        }
        if (config.has("mapped-file")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("mappedfile", config.get("mapped-file").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("mappedfile", "true"));
        }
        if (config.has("check-interval")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("checkInterval", config.get("check-interval").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("checkInterval", "0"));
        }
        if (config.has("modification-test-interval")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("modificationTestInterval", config.get("modification-test-interval").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("modificationTestInterval", "4"));
        }
        if (config.has("recompile-on-fail")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("recompileOnFail", config.get("recompile-on-fail").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("recompileOnFail", "false"));
        }
        if (config.has("smap")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("suppressSmap", config.get("smap").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("suppressSmap", "false"));
        }
        if (config.has("dump-smap")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("dumpSmap", config.get("dump-smap").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("dumpSmap", "false"));
        }
        if (config.has("generate-strings-as-char-arrays")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("genStringAsCharArray", config.get("generate-strings-as-char-arrays").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("genStringAsCharArray", "false"));
        }
        if (config.has("error-on-use-bean-invalid-class-attribute")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("errorOnUseBeanInvalidClassAttribute", config.get("error-on-use-bean-invalid-class-attribute").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("errorOnUseBeanInvalidClassAttribute", "false"));
        }
        if (config.has("scratch-dir")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("scratchdir", config.get("scratch-dir").asString()));
        }
        if (config.has("source-vm")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("compilerSourceVM", config.get("source-vm").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("compilerSourceVM", "1.5"));
        }
        if (config.has("target-vm")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("compilerTargetVM", config.get("target-vm").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("compilerTargetVM", "1.5"));
        }
        if (config.has("java-encoding")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("javaEncoding", config.get("java-encoding").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("javaEncoding", "UTF8"));
        }
        if (config.has("x-powered-by")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("xpoweredBy", config.get("x-powered-by").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("xpoweredBy", "true"));
        }
        if (config.has("display-source-fragment")) {
            initParams.add(SharedWebMetaDataBuilder.createParameter("displaySourceFragment", config.get("display-source-fragment").asString()));
        } else {
            initParams.add(SharedWebMetaDataBuilder.createParameter("displaySourceFragment", "true"));
        }
        servlet.setInitParam(initParams);
        metadata.getServlets().add((MappableMetaData)servlet);
        SharedWebMetaDataBuilder.addServletMapping("jsp", metadata, "*.jsp", "*.jspx");
    }

    static ParamValueMetaData createParameter(String name, String value) {
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(name);
        param.setParamValue(value);
        return param;
    }

    static void addServletMapping(String servlet, WebMetaData metadata, String ... names) {
        ArrayList<ServletMappingMetaData> mappings = metadata.getServletMappings();
        if (mappings == null) {
            mappings = new ArrayList<ServletMappingMetaData>();
            metadata.setServletMappings(mappings);
        }
        ServletMappingMetaData mapping = new ServletMappingMetaData();
        mapping.setUrlPatterns(Arrays.asList(names));
        mapping.setServletName(servlet);
        mappings.add(mapping);
    }

    static MimeMappingMetaData createMimeMapping(String extension, String mimeType) {
        MimeMappingMetaData mapping = new MimeMappingMetaData();
        mapping.setExtension(extension);
        mapping.setMimeType(mimeType);
        return mapping;
    }

    static void createMappings(List<MimeMappingMetaData> mappings) {
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("abs", "audio/x-mpeg"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("ai", "application/postscript"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("aif", "audio/x-aiff"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("aifc", "audio/x-aiff"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("aiff", "audio/x-aiff"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("aim", "application/x-aim"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("art", "image/x-jg"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("asf", "video/x-ms-asf"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("asx", "video/x-ms-asf"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("au", "audio/basic"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("avi", "video/x-msvideo"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("avx", "video/x-rad-screenplay"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("bcpio", "application/x-bcpio"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("bin", "application/octet-stream"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("bmp", "image/bmp"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("body", "text/html"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("cdf", "application/x-cdf"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("cer", "application/x-x509-ca-cert"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("class", "application/java"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("cpio", "application/x-cpio"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("csh", "application/x-csh"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("css", "text/css"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("dib", "image/bmp"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("doc", "application/msword"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("dtd", "application/xml-dtd"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("dv", "video/x-dv"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("dvi", "application/x-dvi"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("eps", "application/postscript"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("etx", "text/x-setext"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("exe", "application/octet-stream"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("gif", "image/gif"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("gtar", "application/x-gtar"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("gz", "application/x-gzip"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("hdf", "application/x-hdf"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("hqx", "application/mac-binhex40"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("htc", "text/x-component"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("htm", "text/html"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("html", "text/html"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("hqx", "application/mac-binhex40"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("ief", "image/ief"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("jad", "text/vnd.sun.j2me.app-descriptor"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("jar", "application/java-archive"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("java", "text/plain"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("jnlp", "application/x-java-jnlp-file"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("jpe", "image/jpeg"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("jpeg", "image/jpeg"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("jpg", "image/jpeg"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("js", "text/javascript"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("jsf", "text/plain"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("jspf", "text/plain"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("kar", "audio/x-midi"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("latex", "application/x-latex"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("m3u", "audio/x-mpegurl"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("mac", "image/x-macpaint"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("man", "application/x-troff-man"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("mathml", "application/mathml+xml"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("me", "application/x-troff-me"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("mid", "audio/x-midi"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("midi", "audio/x-midi"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("mif", "application/x-mif"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("mov", "video/quicktime"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("movie", "video/x-sgi-movie"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("mp1", "audio/x-mpeg"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("mp2", "audio/x-mpeg"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("mp3", "audio/x-mpeg"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("mp4", "video/mp4"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("mpa", "audio/x-mpeg"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("mpe", "video/mpeg"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("mpeg", "video/mpeg"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("mpega", "audio/x-mpeg"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("mpg", "video/mpeg"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("mpv2", "video/mpeg2"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("ms", "application/x-wais-source"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("nc", "application/x-netcdf"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("oda", "application/oda"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("odb", "application/vnd.oasis.opendocument.database"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("odc", "application/vnd.oasis.opendocument.chart"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("odf", "application/vnd.oasis.opendocument.formula"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("odg", "application/vnd.oasis.opendocument.graphics"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("odi", "application/vnd.oasis.opendocument.image"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("odm", "application/vnd.oasis.opendocument.text-master"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("odp", "application/vnd.oasis.opendocument.presentation"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("ods", "application/vnd.oasis.opendocument.spreadsheet"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("odt", "application/vnd.oasis.opendocument.text"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("otg ", "application/vnd.oasis.opendocument.graphics-template"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("oth", "application/vnd.oasis.opendocument.text-web"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("otp", "application/vnd.oasis.opendocument.presentation-template"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("ots", "application/vnd.oasis.opendocument.spreadsheet-template "));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("ott", "application/vnd.oasis.opendocument.text-template"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("ogx", "application/ogg"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("ogv", "video/ogg"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("oga", "audio/ogg"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("ogg", "audio/ogg"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("spx", "audio/ogg"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("flac", "audio/flac"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("anx", "application/annodex"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("axa", "audio/annodex"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("axv", "video/annodex"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("xspf", "application/xspf+xml"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("pbm", "image/x-portable-bitmap"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("pct", "image/pict"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("pdf", "application/pdf"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("pgm", "image/x-portable-graymap"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("pic", "image/pict"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("pict", "image/pict"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("pls", "audio/x-scpls"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("png", "image/png"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("pnm", "image/x-portable-anymap"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("pnt", "image/x-macpaint"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("ppm", "image/x-portable-pixmap"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("ppt", "application/powerpoint"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("ps", "application/postscript"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("psd", "image/x-photoshop"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("qt", "video/quicktime"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("qti", "image/x-quicktime"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("qtif", "image/x-quicktime"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("ras", "image/x-cmu-raster"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("rdf", "application/rdf+xml"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("rgb", "image/x-rgb"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("rm", "application/vnd.rn-realmedia"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("roff", "application/x-troff"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("rtf", "application/rtf"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("rtx", "text/richtext"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("sh", "application/x-sh"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("shar", "application/x-shar"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("smf", "audio/x-midi"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("sit", "application/x-stuffit"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("snd", "audio/basic"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("src", "application/x-wais-source"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("sv4cpio", "application/x-sv4cpio"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("sv4crc", "application/x-sv4crc"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("swf", "application/x-shockwave-flash"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("t", "application/x-troff"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("tar", "application/x-tar"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("tcl", "application/x-tcl"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("tex", "application/x-tex"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("texi", "application/x-texinfo"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("texinfo", "application/x-texinfo"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("tif", "image/tiff"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("tiff", "image/tiff"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("tr", "application/x-troff"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("tsv", "text/tab-separated-values"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("txt", "text/plain"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("ulw", "audio/basic"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("ustar", "application/x-ustar"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("vxml", "application/voicexml+xml"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("xbm", "image/x-xbitmap"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("xht", "application/xhtml+xml"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("xhtml", "application/xhtml+xml"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("xml", "application/xml"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("xpm", "image/x-xpixmap"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("xsl", "application/xml"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("xslt", "application/xslt+xml"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("xul", "application/vnd.mozilla.xul+xml"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("xwd", "image/x-xwindowdump"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("wav", "audio/x-wav"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("svg", "image/svg+xml"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("svgz", "image/svg+xml"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("vsd", "application/x-visio"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("wbmp", "image/vnd.wap.wbmp"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("wml", "text/vnd.wap.wml"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("wmlc", "application/vnd.wap.wmlc"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("wmls", "text/vnd.wap.wmlscript"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("wmlscriptc", "application/vnd.wap.wmlscriptc"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("wmv", "video/x-ms-wmv"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("wrl", "x-world/x-vrml"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("wsdl", "text/xml"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("xsd", "text/xml"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("Z", "application/x-compress"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("z", "application/x-compress"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("zip", "application/zip"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("xls", "application/vnd.ms-excel"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("doc", "application/vnd.ms-word"));
        mappings.add(SharedWebMetaDataBuilder.createMimeMapping("ppt", "application/vnd.ms-powerpoint"));
    }

    static {
        SharedWebMetaDataBuilder.createMappings(mimeMappings);
    }
}

