/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import javax.management.MBeanServer;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.catalina.core.JasperListener;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardService;
import org.apache.tomcat.util.Constants;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.WebServer;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class WebServerService
implements WebServer,
Service<WebServer> {
    private static final String JBOSS_WEB = "jboss.web";
    private final String defaultHost;
    private final boolean useNative;
    private final String instanceId;
    private final String tempPathName;
    private Engine engine;
    private StandardServer server;
    private StandardService service;
    private final InjectedValue<MBeanServer> mbeanServer = new InjectedValue();
    private final InjectedValue<PathManager> pathManagerInjector = new InjectedValue();

    public WebServerService(String defaultHost, boolean useNative, String instanceId, String tempPathName) {
        this.defaultHost = defaultHost;
        this.useNative = useNative;
        this.instanceId = instanceId;
        this.tempPathName = tempPathName;
    }

    public synchronized void start(StartContext context) throws StartException {
        MBeanServer mbeanServer;
        if (Constants.ENABLE_MODELER && (mbeanServer = (MBeanServer)this.mbeanServer.getOptionalValue()) != null) {
            Registry.getRegistry(null, null).setMBeanServer(mbeanServer);
        }
        System.setProperty("catalina.home", ((PathManager)this.pathManagerInjector.getValue()).getPathEntry(this.tempPathName).resolvePath());
        StandardServer server = new StandardServer();
        StandardService service = new StandardService();
        service.setName(JBOSS_WEB);
        service.setServer((Server)server);
        server.addService((org.apache.catalina.Service)service);
        StandardEngine engine = new StandardEngine();
        engine.setName(JBOSS_WEB);
        engine.setService((org.apache.catalina.Service)service);
        engine.setDefaultHost(this.defaultHost);
        if (this.instanceId != null) {
            engine.setJvmRoute(this.instanceId);
        }
        service.setContainer((Container)engine);
        if (this.useNative) {
            AprLifecycleListener apr = new AprLifecycleListener();
            apr.setSSLEngine("on");
            server.addLifecycleListener((LifecycleListener)apr);
        }
        server.addLifecycleListener((LifecycleListener)new JasperListener());
        try {
            server.init();
            server.start();
        }
        catch (Exception e) {
            throw new StartException(WebMessages.MESSAGES.errorStartingWeb(), (Throwable)e);
        }
        this.server = server;
        this.service = service;
        this.engine = engine;
    }

    public synchronized void stop(StopContext context) {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.engine = null;
        this.service = null;
        this.server = null;
    }

    public synchronized WebServer getValue() throws IllegalStateException {
        return this;
    }

    @Override
    public synchronized void addConnector(Connector connector) {
        StandardService service = this.service;
        service.addConnector(connector);
    }

    @Override
    public synchronized void removeConnector(Connector connector) {
        StandardService service = this.service;
        service.removeConnector(connector);
    }

    @Override
    public synchronized void addHost(Host host) {
        Engine engine = this.engine;
        engine.addChild((Container)host);
    }

    @Override
    public synchronized void removeHost(Host host) {
        Engine engine = this.engine;
        engine.removeChild((Container)host);
    }

    InjectedValue<MBeanServer> getMbeanServer() {
        return this.mbeanServer;
    }

    InjectedValue<PathManager> getPathManagerInjector() {
        return this.pathManagerInjector;
    }

    @Override
    public StandardServer getServer() {
        return this.server;
    }

    @Override
    public StandardService getService() {
        return this.service;
    }
}

