/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.server.mgmt.domain.HttpManagement;

public class WelcomeContextConsoleServlet
extends HttpServlet {
    private static final String CONSOLE_PATH = "/console";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final int DEFAULT_PORT = 80;
    private static final int SECURE_DEFAULT_PORT = 443;
    private final boolean hasConsole;
    private final int consolePort;
    private final int consoleSecurePort;
    private final NetworkInterfaceBinding consoleNetworkInterface;
    private final NetworkInterfaceBinding secureConsoleNetworkInterface;
    private final String noconsole = "noconsole.html";
    private final String noredirect = "noredirect.html";

    WelcomeContextConsoleServlet(HttpManagement httpManagement) {
        if (httpManagement != null) {
            this.consolePort = httpManagement.getHttpPort();
            this.consoleSecurePort = httpManagement.getHttpsPort();
            this.consoleNetworkInterface = httpManagement.getHttpNetworkInterfaceBinding();
            this.secureConsoleNetworkInterface = httpManagement.getHttpsNetworkInterfaceBinding();
            this.hasConsole = this.consolePort > -1 || this.consoleSecurePort > -1;
        } else {
            this.hasConsole = false;
            this.consolePort = -1;
            this.consoleSecurePort = -1;
            this.consoleNetworkInterface = null;
            this.secureConsoleNetworkInterface = null;
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String target = "noconsole.html";
        if (this.hasConsole) {
            InetAddress inboundAddress = InetAddress.getByName(req.getLocalAddr());
            boolean secureRedirect = this.secureRedirect(req.isSecure());
            NetworkInterfaceBinding interfaceBinding = secureRedirect ? this.secureConsoleNetworkInterface : this.consoleNetworkInterface;
            String redirectHost = this.getRedirectHost(interfaceBinding, inboundAddress, req.getServerName());
            target = redirectHost != null ? (secureRedirect ? this.assembleURI(HTTPS, redirectHost, this.consoleSecurePort, 443, CONSOLE_PATH) : this.assembleURI(HTTP, redirectHost, this.consolePort, 80, CONSOLE_PATH)) : "noredirect.html";
        }
        resp.sendRedirect(target);
    }

    private String assembleURI(String scheme, String host, int port, int defaultPort, String uri) throws IOException {
        URI redirectUri;
        try {
            redirectUri = port != defaultPort ? new URI(scheme, null, host, port, uri, null, null) : new URI(scheme, null, host, -1, uri, null, null);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return redirectUri.toString();
    }

    private boolean secureRedirect(boolean inboundSecure) {
        if (inboundSecure) {
            return this.consoleSecurePort > -1;
        }
        return !(this.consolePort > -1);
    }

    private String getRedirectHost(NetworkInterfaceBinding chosenBinding, InetAddress inboundAddress, String headerHost) {
        InetAddress managementAddress = chosenBinding.getAddress();
        if (managementAddress.equals(inboundAddress) || managementAddress.isAnyLocalAddress()) {
            return headerHost;
        }
        if (managementAddress.isLoopbackAddress() && inboundAddress.isLoopbackAddress()) {
            return managementAddress.getHostAddress();
        }
        return null;
    }
}

