/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers.annotation;

import javax.xml.ws.Service;
import org.jboss.as.ee.component.InjectionTargetDescription;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefHandler;

public abstract class AbstractWebServiceRefAnnotation<E extends AnnotationTarget> {
    protected final CompositeIndex index;

    protected AbstractWebServiceRefAnnotation(CompositeIndex index) {
        this.index = index;
    }

    public UnifiedServiceRefMetaData process(AnnotationInstance annotationInstance, E annotationTarget, UnifiedVirtualFile vfs) {
        if (annotationInstance == null) {
            return null;
        }
        return this.createServiceRef(annotationInstance, annotationTarget, vfs);
    }

    protected UnifiedServiceRefMetaData createServiceRef(AnnotationInstance annotationInstance, E annotationTarget, UnifiedVirtualFile vfs) {
        DotName value;
        AnnotationValue declaredTypeValue;
        DotName declaredType;
        String wsdlLocationValue;
        String nameValue;
        UnifiedServiceRefMetaData ref = new UnifiedServiceRefMetaData(vfs);
        AnnotationValue declaredNameValue = annotationInstance.value("name");
        String string = nameValue = declaredNameValue == null ? "" : declaredNameValue.asString();
        if (nameValue.length() == 0) {
            nameValue = this.getName(annotationTarget);
        }
        ref.setServiceRefName(nameValue);
        AnnotationValue declaredWsdlLocation = annotationInstance.value("wsdlLocation");
        String string2 = wsdlLocationValue = declaredWsdlLocation == null ? "" : declaredWsdlLocation.asString();
        if (wsdlLocationValue.length() > 0) {
            ref.setWsdlFile(wsdlLocationValue);
        }
        DotName dotName = declaredType = (declaredTypeValue = annotationInstance.value("type")) != null ? declaredTypeValue.asClass().name() : null;
        if (declaredType != null && declaredType.toString() != Object.class.getName()) {
            ref.setServiceRefType(declaredType.toString());
        } else {
            ref.setServiceRefType(this.getType(annotationTarget));
        }
        AnnotationValue declaredValue = annotationInstance.value("value");
        DotName dotName2 = value = declaredValue != null ? declaredValue.asClass().name() : null;
        if (declaredValue != null && !declaredValue.toString().equals(Service.class.getName())) {
            ref.setServiceInterface(value.toString());
        } else {
            ClassInfo targetClass = this.getTypeInfo(annotationTarget);
            if (targetClass != null) {
                ref.setServiceInterface(this.getTypeInfo(annotationTarget).name().toString());
            }
        }
        boolean isJAXRPC = ref.getMappingFile() != null || "javax.xml.rpc.Service".equals(ref.getServiceInterface());
        ref.setType(isJAXRPC ? ServiceRefHandler.Type.JAXRPC : ServiceRefHandler.Type.JAXWS);
        return ref;
    }

    private boolean isAssignableFrom(ClassInfo classInfo, DotName className) {
        if (classInfo.name().equals((Object)className)) {
            return true;
        }
        ClassInfo superClass = this.index.getClassByName(classInfo.superName());
        if (superClass != null && this.isAssignableFrom(superClass, className)) {
            return true;
        }
        for (DotName superInterface : classInfo.interfaces()) {
            ClassInfo interfaceInfo = this.index.getClassByName(superInterface);
            if (interfaceInfo == null || !this.isAssignableFrom(interfaceInfo, className)) continue;
            return true;
        }
        return false;
    }

    public abstract String getName(E var1);

    public abstract InjectionTargetDescription.Type getInjectionType();

    protected abstract String getInjectionName(E var1);

    protected abstract String getType(E var1);

    protected abstract ClassInfo getTypeInfo(E var1);

    protected abstract String getDeclaringClass(E var1);
}

