/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointMetrics;
import org.jboss.wsf.spi.management.EndpointRegistry;

final class WSEndpointMetrics
implements ModelQueryOperationHandler {
    static final WSEndpointMetrics INSTANCE = new WSEndpointMetrics();
    static final String[] ATTRIBUTES = new String[]{"min-processing-time", "max-processing-time", "average-processing-time", "total-processing-time", "request-count", "response-count", "fault-count"};
    private static final String FALLBACK_MESSAGE = "No metrics available";
    static final String MIN_PROCESSING_TIME = "min-processing-time";
    static final String MAX_PROCESSING_TIME = "max-processing-time";
    static final String AVERAGE_PROCESSING_TIME = "average-processing-time";
    static final String TOTAL_PROCESSING_TIME = "total-processing-time";
    static final String REQUEST_COUNT = "request-count";
    static final String RESPONSE_COUNT = "response-count";
    static final String FAULT_COUNT = "fault-count";

    private WSEndpointMetrics() {
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry().getService(WSServices.REGISTRY_SERVICE);
                    if (controller != null) {
                        try {
                            ModelNode result = WSEndpointMetrics.this.getEndpointMetricsFragment(operation, controller);
                            resultHandler.handleResultFragment(ResultHandler.EMPTY_LOCATION, result);
                            resultHandler.handleResultComplete();
                        }
                        catch (Exception e) {
                            throw new OperationFailedException(new ModelNode().set(WSEndpointMetrics.getFallbackMessage() + ": " + e.getMessage()));
                        }
                    } else {
                        WSEndpointMetrics.fallback(resultHandler, WSEndpointMetrics.getFallbackMessage());
                    }
                }
            });
        } else {
            WSEndpointMetrics.fallback(resultHandler, WSEndpointMetrics.getFallbackMessage());
        }
        return new BasicOperationResult();
    }

    private ModelNode getEndpointMetricsFragment(ModelNode operation, ServiceController<?> controller) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String endpointId = address.getLastElement().getValue();
        String metricName = operation.require("name").asString();
        String webContext = endpointId.substring(0, endpointId.indexOf(":"));
        String endpointName = endpointId.substring(endpointId.indexOf(":") + 1);
        ObjectName endpointObjectName = null;
        try {
            endpointObjectName = new ObjectName("jboss.ws:context=" + webContext + ",endpoint=" + endpointName);
        }
        catch (MalformedObjectNameException e) {
            throw new OperationFailedException(new ModelNode().set(e.getMessage()));
        }
        EndpointRegistry registry = (EndpointRegistry)controller.getValue();
        Endpoint endpoint = registry.getEndpoint(endpointObjectName);
        ModelNode result = new ModelNode();
        if (endpoint != null && endpoint.getEndpointMetrics() != null) {
            EndpointMetrics endpointMetrics = endpoint.getEndpointMetrics();
            if (MIN_PROCESSING_TIME.equals(metricName)) {
                result.set(String.valueOf(endpointMetrics.getMinProcessingTime()));
            } else if (MAX_PROCESSING_TIME.equals(metricName)) {
                result.set(String.valueOf(endpointMetrics.getMaxProcessingTime()));
            } else if (AVERAGE_PROCESSING_TIME.equals(metricName)) {
                result.set(String.valueOf(endpointMetrics.getTotalProcessingTime()));
            } else if (TOTAL_PROCESSING_TIME.equals(metricName)) {
                result.set(String.valueOf(endpointMetrics.getTotalProcessingTime()));
            } else if (REQUEST_COUNT.equals(metricName)) {
                result.set(String.valueOf(endpointMetrics.getRequestCount()));
            } else if (RESPONSE_COUNT.equals(metricName)) {
                result.set(String.valueOf(endpointMetrics.getResponseCount()));
            } else if (FAULT_COUNT.equals(metricName)) {
                result.set(String.valueOf(endpointMetrics.getFaultCount()));
            }
        } else {
            result.set(WSEndpointMetrics.getFallbackMessage());
        }
        return result;
    }

    private static String getFallbackMessage() {
        return FALLBACK_MESSAGE;
    }

    private static void fallback(ResultHandler resultHandler, String msg) {
        ModelNode fallbackFragmenet = new ModelNode().set(msg);
        resultHandler.handleResultFragment(ResultHandler.EMPTY_LOCATION, fallbackFragmenet);
        resultHandler.handleResultComplete();
    }
}

