/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.webservices.dmr.Namespace;
import org.jboss.as.webservices.dmr.WSEndpointAdd;
import org.jboss.as.webservices.dmr.WSEndpointMetrics;
import org.jboss.as.webservices.dmr.WSEndpointRemove;
import org.jboss.as.webservices.dmr.WSSubsystemAdd;
import org.jboss.as.webservices.dmr.WSSubsystemDescribe;
import org.jboss.as.webservices.dmr.WSSubsystemProviders;
import org.jboss.as.webservices.dmr.WebservicesSubsystemParser;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public final class WSExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.webservices");
    public static final String SUBSYSTEM_NAME = "webservices";

    public void initialize(ExtensionContext context) {
        log.debugf("Activating WebServices Extension", new Object[0]);
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        subsystem.registerXMLElementWriter((XMLElementWriter)WebservicesSubsystemParser.getInstance());
        ModelNodeRegistration registration = subsystem.registerSubsystemModel(WSSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationHandler)WSSubsystemAdd.INSTANCE, WSSubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationHandler)WSSubsystemDescribe.INSTANCE, WSSubsystemProviders.SUBSYSTEM_DESCRIBE, false, OperationEntry.EntryType.PRIVATE);
        ModelNodeRegistration endpoints = registration.registerSubModel(PathElement.pathElement((String)"endpoint"), WSSubsystemProviders.ENDPOINT_DESCRIPTION);
        endpoints.registerOperationHandler("add", (OperationHandler)WSEndpointAdd.INSTANCE, WSSubsystemProviders.ENDPOINT_ADD_DESCRIPTION, false, OperationEntry.EntryType.PRIVATE);
        endpoints.registerOperationHandler("remove", (OperationHandler)WSEndpointRemove.INSTANCE, WSSubsystemProviders.ENDPOINT_REMOVE_DESCRIPTION, false, OperationEntry.EntryType.PRIVATE);
        for (String attributeName : WSEndpointMetrics.ATTRIBUTES) {
            endpoints.registerMetric(attributeName, (OperationHandler)WSEndpointMetrics.INSTANCE);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)WebservicesSubsystemParser.getInstance());
    }
}

