/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr.management;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.webservices.dmr.management.WSAbstractOperationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointMetrics;
import org.jboss.wsf.spi.management.EndpointRegistry;

public final class WSEndpointMetricsOperationHandler
extends WSAbstractOperationHandler
implements ModelQueryOperationHandler {
    public static final WSEndpointMetricsOperationHandler INSTANCE = new WSEndpointMetricsOperationHandler();
    public static final String[] ATTRIBUTES = new String[]{"start-time", "stop-time", "min-processing-time", "max-processing-time", "total-processing-time", "request-count", "response-count", "fault-count"};
    private static final String CONTEXT = "context";
    private static final String ENDPOINT = "endpoint";
    private static final String NAME = "name";
    private static final String FALLBACK_MESSAGE = "No metrics available";
    private static final String START_TIME = "start-time";
    private static final String STOP_TIME = "stop-time";
    private static final String MIN_PROCESSING_TIME = "min-processing-time";
    private static final String MAX_PROCESSING_TIME = "max-processing-time";
    private static final String TOTAL_PROCESSING_TIME = "total-processing-time";
    private static final String REQUEST_COUNT = "request-count";
    private static final String RESPONSE_COUNT = "response-count";
    private static final String FAULT_COUNT = "fault-count";

    private WSEndpointMetricsOperationHandler() {
    }

    @Override
    protected ModelNode getManagementOperationResultFragment(ModelNode operation, ServiceController<?> controller) throws OperationFailedException {
        String webContext = operation.require(CONTEXT).asString();
        String endpointName = operation.require(ENDPOINT).asString();
        ObjectName endpointObjectName = null;
        try {
            endpointObjectName = new ObjectName("jboss.ws:context=" + webContext + ",endpoint=" + endpointName);
        }
        catch (MalformedObjectNameException e) {
            throw new OperationFailedException(new ModelNode().set(e.getMessage()));
        }
        String metricName = operation.require(NAME).asString();
        EndpointRegistry registry = (EndpointRegistry)controller.getValue();
        Endpoint endpoint = registry.getEndpoint(endpointObjectName);
        ModelNode result = new ModelNode();
        if (endpoint != null && endpoint.getEndpointMetrics() != null) {
            EndpointMetrics endpointMetrics = endpoint.getEndpointMetrics();
            if (START_TIME.equals(metricName)) {
                result.set(String.valueOf(endpointMetrics.getStartTime()));
            } else if (STOP_TIME.equals(metricName)) {
                result.set(String.valueOf(endpointMetrics.getStopTime()));
            } else if (MIN_PROCESSING_TIME.equals(metricName)) {
                result.set(String.valueOf(endpointMetrics.getMinProcessingTime()));
            } else if (MAX_PROCESSING_TIME.equals(metricName)) {
                result.set(String.valueOf(endpointMetrics.getMaxProcessingTime()));
            } else if (TOTAL_PROCESSING_TIME.equals(metricName)) {
                result.set(String.valueOf(endpointMetrics.getTotalProcessingTime()));
            } else if (REQUEST_COUNT.equals(metricName)) {
                result.set(String.valueOf(endpointMetrics.getRequestCount()));
            } else if (RESPONSE_COUNT.equals(metricName)) {
                result.set(String.valueOf(endpointMetrics.getResponseCount()));
            } else if (FAULT_COUNT.equals(metricName)) {
                result.set(String.valueOf(endpointMetrics.getFaultCount()));
            }
        } else {
            result.set(this.getFallbackMessage());
        }
        return result;
    }

    @Override
    protected String getFallbackMessage() {
        return FALLBACK_MESSAGE;
    }
}

