/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr.management;

import javax.management.ObjectName;
import org.jboss.as.webservices.dmr.management.WSAbstractOperationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointRegistry;

public final class WSEndpointsListOperationHandler
extends WSAbstractOperationHandler {
    public static final String OPERATION_NAME = "list-endpoints";
    public static final WSEndpointsListOperationHandler INSTANCE = new WSEndpointsListOperationHandler();
    private static final String FALLBACK_MESSAGE = "No webservice endpoints available";
    private static final String ENDPOINTS_COUNT = "endpoints-count";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String WSDL = "wsdl";

    private WSEndpointsListOperationHandler() {
    }

    @Override
    protected ModelNode getManagementOperationResultFragment(ModelNode operation, ServiceController<?> controller) {
        EndpointRegistry registry = (EndpointRegistry)controller.getValue();
        ModelNode result = new ModelNode();
        result.get(ENDPOINTS_COUNT).set(registry.getEndpoints().size());
        for (ObjectName obj : registry.getEndpoints()) {
            Endpoint endpoint = registry.getEndpoint(obj);
            String endpointName = obj.toString();
            result.get(endpointName).add(NAME, endpoint.getShortName());
            result.get(endpointName).add(CLASS, endpoint.getTargetBeanName());
            result.get(endpointName).add(WSDL, endpoint.getAddress() + "?wsdl");
        }
        return result;
    }

    @Override
    protected String getFallbackMessage() {
        return FALLBACK_MESSAGE;
    }
}

