/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.ComponentViewInstance;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.weld.CurrentServiceRegistry;
import org.jboss.as.weld.ejb.EjbDescriptorImpl;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.weld.ejb.api.SessionObjectReference;

public class StatefulSessionObjectReferenceImpl
implements SessionObjectReference,
Serializable {
    private volatile boolean removed = false;
    private final Map<String, ServiceName> viewServices;
    private transient StatefulSessionComponent ejbComponent;
    private final ServiceName createServiceName;
    private final Serializable id;

    public StatefulSessionObjectReferenceImpl(EjbDescriptorImpl<?> descriptor) {
        this.createServiceName = descriptor.getCreateServiceName();
        HashMap<String, ServiceName> viewServices = new HashMap<String, ServiceName>();
        for (ViewDescription view : descriptor.getComponentDescription().getViews()) {
            viewServices.put(view.getViewClassName(), view.getServiceName());
        }
        this.id = this.getComponent().createSession();
        this.viewServices = viewServices;
    }

    public synchronized <S> S getBusinessObject(Class<S> businessInterfaceType) {
        if (this.viewServices.containsKey(businessInterfaceType.getName())) {
            ServiceController serviceController = CurrentServiceRegistry.getServiceRegistry().getRequiredService(this.viewServices.get(businessInterfaceType.getName()));
            ComponentView view = (ComponentView)serviceController.getValue();
            ComponentViewInstance instance = view.createInstance(Collections.singletonMap(StatefulSessionComponent.SESSION_ATTACH_KEY, this.id));
            return (S)instance.createProxy();
        }
        throw new IllegalArgumentException("View of type " + businessInterfaceType + " not found on bean " + this.getComponent());
    }

    public void remove() {
        if (!this.isRemoved()) {
            this.getComponent().getCache().remove(this.id);
            this.removed = true;
        }
    }

    public boolean isRemoved() {
        if (!this.removed) {
            return this.getComponent().getCache().get(this.id) == null;
        }
        return true;
    }

    private StatefulSessionComponent getComponent() {
        if (this.ejbComponent == null) {
            ServiceController controller = CurrentServiceRegistry.getServiceRegistry().getRequiredService(this.createServiceName);
            this.ejbComponent = (StatefulSessionComponent)controller.getValue();
        }
        return this.ejbComponent;
    }
}

