/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.common;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.security.auth.callback.CallbackHandler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.plugin.common.ClientCallbackHandler;
import org.jboss.as.plugin.common.ConnectionInfo;
import org.jboss.as.plugin.common.Operations;
import org.jboss.as.plugin.common.Streams;
import org.jboss.dmr.ModelNode;

public abstract class AbstractServerConnection
extends AbstractMojo
implements ConnectionInfo,
Closeable {
    protected static final Object CLIENT_LOCK = new Object();
    private volatile InetAddress address = null;
    private volatile CallbackHandler handler;
    @Parameter(defaultValue="localhost", property="jboss-as.hostname")
    private String hostname;
    @Parameter(defaultValue="9999", property="jboss-as.port")
    private int port;
    @Parameter(property="jboss-as.username")
    private String username;
    @Parameter(property="jboss-as.password")
    private String password;
    private ModelControllerClient client;

    public final String hostname() {
        return this.hostname;
    }

    @Override
    public final int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDomainServer() {
        Object object = CLIENT_LOCK;
        synchronized (object) {
            return this.isDomainServer(this.getClient());
        }
    }

    public abstract String goal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ModelControllerClient getClient() {
        Object object = CLIENT_LOCK;
        synchronized (object) {
            ModelControllerClient result = this.client;
            if (result == null && this.isDomainServer(result = (this.client = ModelControllerClient.Factory.create((InetAddress)this.getHostAddress(), (int)this.getPort(), (CallbackHandler)this.getCallbackHandler())))) {
                result = this.client = DomainClient.Factory.create((ModelControllerClient)result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        Object object = CLIENT_LOCK;
        synchronized (object) {
            Streams.safeClose((Closeable)this.client);
            this.client = null;
        }
    }

    @Override
    public final synchronized InetAddress getHostAddress() {
        InetAddress result = this.address;
        if (result == null) {
            try {
                result = this.address = InetAddress.getByName(this.hostname());
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(String.format("Host name '%s' is invalid.", this.hostname), e);
            }
        }
        return result;
    }

    @Override
    public final synchronized CallbackHandler getCallbackHandler() {
        CallbackHandler result = this.handler;
        if (result == null) {
            result = this.handler = new ClientCallbackHandler(this.username, this.password);
        }
        return result;
    }

    private boolean isDomainServer(ModelControllerClient client) {
        boolean result = false;
        ModelNode op = Operations.createReadAttributeOperation("launch-type");
        try {
            ModelNode opResult = client.execute(op);
            if (Operations.successful(opResult)) {
                result = "DOMAIN".equals(Operations.readResultAsString(opResult));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Error could not execute operation '%s'.", op), e);
        }
        return result;
    }
}

