/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.server;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.plugin.common.Files;
import org.jboss.as.plugin.common.Streams;
import org.jboss.as.plugin.deployment.domain.Domain;
import org.jboss.as.plugin.server.Server;
import org.jboss.as.plugin.server.ServerInfo;

final class DomainServer
extends Server {
    private static final String CONFIG_PATH = "/domain/configuration/";
    private final ServerInfo serverInfo;
    private final Domain domain;
    private volatile boolean isRunning;
    private DomainClient client;
    private final Map<ServerIdentity, ServerStatus> servers;

    public DomainServer(ServerInfo serverInfo, Domain domain) {
        super(serverInfo);
        this.serverInfo = serverInfo;
        this.domain = domain;
        this.isRunning = false;
        this.servers = new HashMap<ServerIdentity, ServerStatus>();
    }

    @Override
    protected void init() throws IOException {
        this.client = DomainClient.Factory.create((InetAddress)this.serverInfo.getConnectionInfo().getHostAddress(), (int)this.serverInfo.getConnectionInfo().getPort(), (CallbackHandler)this.serverInfo.getConnectionInfo().getCallbackHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopServer() {
        block10: {
            try {
                if (this.client == null) break block10;
                try {
                    for (ServerIdentity id : this.servers.keySet()) {
                        ServerStatus status = this.servers.get(id);
                        switch (status) {
                            case STARTED: {
                                this.client.stopServer(id.getHostName(), id.getServerName(), 10L, TimeUnit.SECONDS);
                            }
                        }
                    }
                }
                finally {
                    Streams.safeClose((Closeable)this.client);
                    this.client = null;
                    this.servers.clear();
                }
            }
            finally {
                this.isRunning = false;
            }
        }
    }

    @Override
    public synchronized boolean isRunning() {
        if (this.isRunning) {
            return this.isRunning;
        }
        if (this.client == null) {
            this.isRunning = false;
        } else {
            try {
                Map statuses = this.client.getServerStatuses();
                for (ServerIdentity id : statuses.keySet()) {
                    ServerStatus status = (ServerStatus)statuses.get(id);
                    switch (status) {
                        case STARTED: 
                        case DISABLED: {
                            this.servers.put(id, status);
                        }
                    }
                }
                this.isRunning = statuses.size() == this.servers.size();
            }
            catch (Throwable ignore) {
                this.isRunning = false;
            }
        }
        return this.isRunning;
    }

    public synchronized DomainClient getClient() {
        return this.client;
    }

    @Override
    protected List<String> createLaunchCommand() {
        File jbossHome = this.serverInfo.getJbossHome();
        String javaHome = this.serverInfo.getJavaHome();
        File modulesJar = new File(Files.createPath(jbossHome.getAbsolutePath(), "jboss-modules.jar"));
        if (!modulesJar.exists()) {
            throw new IllegalStateException("Cannot find: " + modulesJar);
        }
        String javaExec = Files.createPath(javaHome, "bin", "java");
        if (javaHome.contains(" ")) {
            javaExec = "\"" + javaExec + "\"";
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(javaExec);
        if (this.serverInfo.getJvmArgs() != null) {
            Collections.addAll(cmd, this.serverInfo.getJvmArgs());
        }
        cmd.add("-Djboss.home.dir=" + jbossHome);
        cmd.add("-Dorg.jboss.boot.log.file=" + jbossHome + "/domain/log/process-controller.log");
        cmd.add("-Dlogging.configuration=file:" + jbossHome + CONFIG_PATH + "logging.properties");
        cmd.add("-Djboss.bundles.dir=" + this.serverInfo.getBundlesDir().getAbsolutePath());
        cmd.add("-jar");
        cmd.add(modulesJar.getAbsolutePath());
        cmd.add("-mp");
        cmd.add(this.serverInfo.getModulesDir().getAbsolutePath());
        cmd.add("org.jboss.as.process-controller");
        cmd.add("-jboss-home");
        cmd.add(jbossHome.getAbsolutePath());
        cmd.add("-jvm");
        cmd.add(javaExec);
        cmd.add("--");
        cmd.add("-Dorg.jboss.boot.log.file=" + jbossHome + "/domain/log/host-controller.log");
        cmd.add("-Dlogging.configuration=file:" + jbossHome + CONFIG_PATH + "logging.properties");
        cmd.add("--");
        cmd.add("-default-jvm");
        cmd.add(javaExec);
        return cmd;
    }

    @Override
    protected void checkServerState() {
    }
}

