/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.plugin.common.DeploymentFailureException;
import org.jboss.as.plugin.common.Operations;
import org.jboss.as.plugin.common.Streams;
import org.jboss.as.plugin.deployment.Deploy;
import org.jboss.as.plugin.deployment.standalone.StandaloneDeployment;
import org.jboss.as.plugin.server.SecurityActions;
import org.jboss.as.plugin.server.Server;
import org.jboss.as.plugin.server.ServerInfo;
import org.jboss.as.plugin.server.StandaloneServer;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.util.artifact.DefaultArtifact;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(phase=LifecyclePhase.PACKAGE)
public class Run
extends Deploy {
    public static final String JBOSS_DIR = "jboss-as-run";
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(alias="jboss-home", property="jboss-as.home")
    private String jbossHome;
    @Parameter(alias="jboss-as-version", defaultValue="7.1.1.Final", property="jboss-as.version")
    private String version;
    @Parameter(alias="modules-path", property="jboss-as.modulesPath")
    private String modulesPath;
    @Parameter(alias="bundles-path", property="jboss-as.bundlesPath")
    private String bundlesPath;
    @Parameter(alias="jvm-args", property="jboss-as.jvmArgs", defaultValue="-Xms64m -Xmx512m -XX:MaxPermSize=256m -Djava.net.preferIPv4Stack=true -Dorg.jboss.resolver.warning=true -Dsun.rmi.dgc.client.gcInterval=3600000 -Dsun.rmi.dgc.server.gcInterval=3600000")
    private String jvmArgs;
    @Parameter(alias="java-home", property="java.home")
    private String javaHome;
    @Parameter(alias="server-config", property="jboss-as.serverConfig")
    private String serverConfig;
    @Parameter(alias="startup-timeout", defaultValue="60", property="jboss-as.startupTimeout")
    private long startupTimeout;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        String[] jvmArgs;
        Log log = this.getLog();
        File deploymentFile = this.file();
        String deploymentName = deploymentFile.getName();
        File targetDir = deploymentFile.getParentFile();
        if (!deploymentFile.exists()) {
            throw new MojoExecutionException(String.format("The deployment '%s' could not be found.", deploymentFile.getAbsolutePath()));
        }
        File jbossHome = this.extractIfRequired(targetDir);
        if (!jbossHome.isDirectory()) {
            throw new MojoExecutionException(String.format("JBOSS_HOME '%s' is not a valid directory.", jbossHome));
        }
        String javaHome = this.javaHome == null ? SecurityActions.getEnvironmentVariable("JAVA_HOME") : this.javaHome;
        ServerInfo serverInfo = ServerInfo.of(this, javaHome, jbossHome, this.modulesPath, this.bundlesPath, jvmArgs = this.jvmArgs == null ? null : this.jvmArgs.split("\\s+"), this.serverConfig, this.startupTimeout);
        if (!serverInfo.getModulesDir().isDirectory()) {
            throw new MojoExecutionException(String.format("Modules path '%s' is not a valid directory.", this.modulesPath));
        }
        if (!serverInfo.getBundlesDir().isDirectory()) {
            throw new MojoExecutionException(String.format("Bundles path '%s' is not a valid directory.", this.bundlesPath));
        }
        log.info((CharSequence)String.format("JAVA_HOME=%s", javaHome));
        log.info((CharSequence)String.format("JBOSS_HOME=%s%n", jbossHome));
        try {
            final StandaloneServer server = new StandaloneServer(serverInfo);
            Thread shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    server.stop();
                    try {
                        TimeUnit.MILLISECONDS.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            SecurityActions.addShutdownHook(shutdownThread);
            log.info((CharSequence)"Server is starting up. Press CTRL + C to stop the server.");
            server.start();
            ((Server)server).checkServerState();
            if (((Server)server).isRunning()) {
                log.info((CharSequence)String.format("Deploying application '%s'%n", deploymentFile.getName()));
                ModelControllerClient client = ((Server)server).getClient();
                StandaloneDeployment deployment = StandaloneDeployment.create(client, deploymentFile, deploymentName, this.getType());
                switch (this.executeDeployment(client, deployment)) {
                    case REQUIRES_RESTART: {
                        client.execute(Operations.createOperation("reload"));
                        break;
                    }
                }
            } else {
                throw new DeploymentFailureException("Cannot deploy to a server that is not running.");
            }
            while (((Server)server).isRunning()) {
                TimeUnit.SECONDS.sleep(1L);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("The server failed to start", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extractIfRequired(File buildDir) throws MojoFailureException, MojoExecutionException {
        ArtifactResult result;
        if (this.jbossHome != null) {
            return new File(this.jbossHome);
        }
        ArtifactRequest request = new ArtifactRequest();
        String jbossAsArtifact = String.format("org.jboss.as:jboss-as-dist:zip:%s", this.version);
        request.setArtifact((Artifact)new DefaultArtifact(jbossAsArtifact));
        request.setRepositories(this.remoteRepos);
        this.getLog().info((CharSequence)String.format("Resolving artifact %s from %s", jbossAsArtifact, this.remoteRepos));
        try {
            result = this.repoSystem.resolveArtifact(this.repoSession, request);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        byte[] buff = new byte[1024];
        File target = new File(buildDir, JBOSS_DIR);
        if (target.exists()) {
            target.delete();
        }
        ZipFile file = null;
        try {
            file = new ZipFile(result.getArtifact().getFile());
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File extractTarget = new File(target.getAbsolutePath(), entry.getName());
                if (entry.isDirectory()) {
                    extractTarget.mkdirs();
                    continue;
                }
                File parent = new File(extractTarget.getParent());
                parent.mkdirs();
                BufferedInputStream in = new BufferedInputStream(file.getInputStream(entry));
                try {
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(extractTarget));
                    try {
                        int read = 0;
                        while ((read = in.read(buff)) != -1) {
                            out.write(buff, 0, read);
                        }
                    }
                    finally {
                        Streams.safeClose(out);
                    }
                }
                finally {
                    Streams.safeClose(in);
                }
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(String.format("Error extracting '%s'", file == null ? "null file" : file.getName()), e);
            }
            catch (Throwable throwable) {
                Streams.safeClose(file);
                throw throwable;
            }
        }
        Streams.safeClose(file);
        return new File(target.getAbsoluteFile(), String.format("jboss-as-%s", this.version));
    }

    @Override
    public String goal() {
        return "run";
    }
}

