/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.server;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class Arguments {
    private final Map<String, Argument> map = new LinkedHashMap<String, Argument>();

    Arguments() {
    }

    public void clear() {
        this.map.clear();
    }

    public void add(String arg) {
        if (arg != null) {
            Argument argument = Arguments.parse(arg);
            this.map.put(argument.getKey(), argument);
        }
    }

    public void add(String key, String value) {
        if (key != null) {
            Argument argument = key.startsWith("-D") ? (value == null ? Arguments.createSystemProperty(key) : Arguments.createSystemProperty(key, value)) : (value == null ? Arguments.create(key) : Arguments.create(key, value));
            this.map.put(key, argument);
        }
    }

    public void addAll(String ... args) {
        if (args != null) {
            for (String arg : args) {
                this.add(arg);
            }
        }
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    public String get(String key) {
        Argument arg = this.map.get(key);
        if (arg != null) {
            return arg.getValue();
        }
        return null;
    }

    public List<String> asList() {
        ArrayList<String> result = new ArrayList<String>();
        for (Argument arg : this.map.values()) {
            result.add(arg.asCommandLineArgument());
        }
        return result;
    }

    void add(Argument argument) {
        if (argument != null) {
            this.map.put(argument.getKey(), argument);
        }
    }

    public static Argument parse(String arg) {
        String value;
        String key;
        if (arg.startsWith("-D")) {
            String value2;
            String key2;
            int index = arg.indexOf(61);
            if (index == -1) {
                key2 = arg.substring(2);
                value2 = null;
            } else {
                key2 = arg.substring(2, index);
                value2 = arg.length() < index + 1 ? null : arg.substring(index + 1);
            }
            return new SystemPropertyArgument(key2, value2);
        }
        int index = arg.indexOf(61);
        if (index == -1) {
            key = arg;
            value = null;
        } else {
            key = arg.substring(0, index);
            value = arg.length() < index + 1 ? null : arg.substring(index + 1);
        }
        return new DefaultArgument(key, value);
    }

    private static Argument create(String arg) {
        return new DefaultArgument(arg, null);
    }

    private static Argument create(String key, String value) {
        return new DefaultArgument(key, value);
    }

    private static Argument createSystemProperty(String arg) {
        return new SystemPropertyArgument(arg, null);
    }

    private static Argument createSystemProperty(String key, String value) {
        return new SystemPropertyArgument(key, value);
    }

    private static final class DefaultArgument
    extends Argument {
        private final String cliArg;

        public DefaultArgument(String key, String value) {
            super(key, value);
            this.cliArg = value != null ? key + "=" + value : key;
        }

        @Override
        public String asCommandLineArgument() {
            return this.cliArg;
        }
    }

    private static final class SystemPropertyArgument
    extends Argument {
        private final String cliArg;

        public SystemPropertyArgument(String key, String value) {
            super(key, value);
            this.cliArg = value != null ? "-D" + key + "=" + value : "-D" + key;
        }

        @Override
        public String asCommandLineArgument() {
            return this.cliArg;
        }
    }

    public static abstract class Argument {
        private final String key;
        private final String value;

        protected Argument(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public abstract String asCommandLineArgument();
    }
}

