/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.currentinvocation;

import java.util.EmptyStackException;
import java.util.Stack;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrentInvocation {
    private static final Logger logger = Logger.getLogger(CurrentInvocation.class);
    private static final StackThreadLocal<Invocation> registry = new StackThreadLocal();

    public static Invocation getCurrentInvocation() {
        try {
            return CurrentInvocation.getRegistry().peek();
        }
        catch (EmptyStackException ese) {
            return null;
        }
    }

    static void registerInvocation(Invocation invocation) {
        logger.trace((Object)("Placing invocation " + invocation + " into scope for Thread " + Thread.currentThread().toString()));
        CurrentInvocation.getRegistry().push(invocation);
    }

    static void deregisterCurrentInvocation() {
        Invocation current = CurrentInvocation.getRegistry().pop();
        logger.trace((Object)("Cleared Thread " + Thread.currentThread().toString() + " of association with Invocation " + current));
    }

    private static StackThreadLocal<Invocation> getRegistry() {
        return registry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StackThreadLocal<T extends Invocation>
    extends ThreadLocal<Stack<T>> {
        private StackThreadLocal() {
        }

        public T peek() {
            return (T)((Invocation)((Stack)this.get()).peek());
        }

        public void push(T invocation) {
            ((Stack)this.get()).push(invocation);
        }

        public T pop() {
            return (T)((Invocation)((Stack)this.get()).pop());
        }

        @Override
        protected Stack<T> initialValue() {
            return new Stack();
        }
    }
}

