/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.constpool;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.classfilewriter.WritableEntry;
import org.jboss.classfilewriter.constpool.ClassEntry;
import org.jboss.classfilewriter.constpool.ConstPoolEntry;
import org.jboss.classfilewriter.constpool.DoubleEntry;
import org.jboss.classfilewriter.constpool.FieldRefEntry;
import org.jboss.classfilewriter.constpool.FloatEntry;
import org.jboss.classfilewriter.constpool.IntegerEntry;
import org.jboss.classfilewriter.constpool.InterfaceMethodRefEntry;
import org.jboss.classfilewriter.constpool.LongEntry;
import org.jboss.classfilewriter.constpool.MethodRefEntry;
import org.jboss.classfilewriter.constpool.NameAndTypeEntry;
import org.jboss.classfilewriter.constpool.StringEntry;
import org.jboss.classfilewriter.constpool.Utf8Entry;
import org.jboss.classfilewriter.util.ByteArrayDataOutputStream;

public class ConstPool
implements WritableEntry {
    private final LinkedHashMap<Short, ConstPoolEntry> entries = new LinkedHashMap();
    private final Map<String, Short> utf8Locations = new HashMap<String, Short>();
    private final Map<String, Short> classLocations = new HashMap<String, Short>();
    private final Map<String, Short> stringLocations = new HashMap<String, Short>();
    private final Map<NameAndType, Short> nameAndTypeLocations = new HashMap<NameAndType, Short>();
    private final Map<MemberInfo, Short> fieldLocations = new HashMap<MemberInfo, Short>();
    private final Map<MemberInfo, Short> methodLocations = new HashMap<MemberInfo, Short>();
    private final Map<MemberInfo, Short> interfaceMethodLocations = new HashMap<MemberInfo, Short>();
    private final Map<Integer, Short> integerLocations = new HashMap<Integer, Short>();
    private final Map<Float, Short> floatLocations = new HashMap<Float, Short>();
    private final Map<Long, Short> longLocations = new HashMap<Long, Short>();
    private final Map<Double, Short> doubleLocations = new HashMap<Double, Short>();
    private short count = 1;
    private short constPoolSize = 1;

    public short addUtf8Entry(String entry) {
        if (this.utf8Locations.containsKey(entry)) {
            return this.utf8Locations.get(entry);
        }
        short s = this.count;
        this.count = (short)(s + 1);
        short index = s;
        this.constPoolSize = (short)(this.constPoolSize + 1);
        this.entries.put(index, new Utf8Entry(entry));
        this.utf8Locations.put(entry, index);
        return index;
    }

    public short addClassEntry(String className) {
        if (this.classLocations.containsKey(className = className.replace('.', '/'))) {
            return this.classLocations.get(className);
        }
        short utf8Location = this.addUtf8Entry(className);
        short s = this.count;
        this.count = (short)(s + 1);
        short index = s;
        this.constPoolSize = (short)(this.constPoolSize + 1);
        this.entries.put(index, new ClassEntry(utf8Location));
        this.classLocations.put(className, index);
        return index;
    }

    public short addStringEntry(String string) {
        if (this.stringLocations.containsKey(string)) {
            return this.stringLocations.get(string);
        }
        short utf8Location = this.addUtf8Entry(string);
        short s = this.count;
        this.count = (short)(s + 1);
        short index = s;
        this.constPoolSize = (short)(this.constPoolSize + 1);
        this.entries.put(index, new StringEntry(utf8Location));
        this.stringLocations.put(string, index);
        return index;
    }

    public short addIntegerEntry(int entry) {
        if (this.integerLocations.containsKey(entry)) {
            return this.integerLocations.get(entry);
        }
        short s = this.count;
        this.count = (short)(s + 1);
        short index = s;
        this.constPoolSize = (short)(this.constPoolSize + 1);
        this.entries.put(index, new IntegerEntry(entry));
        this.integerLocations.put(entry, index);
        return index;
    }

    public short addFloatEntry(float entry) {
        if (this.floatLocations.containsKey(Float.valueOf(entry))) {
            return this.floatLocations.get(Float.valueOf(entry));
        }
        short s = this.count;
        this.count = (short)(s + 1);
        short index = s;
        this.constPoolSize = (short)(this.constPoolSize + 1);
        this.entries.put(index, new FloatEntry(entry));
        this.floatLocations.put(Float.valueOf(entry), index);
        return index;
    }

    public short addLongEntry(long entry) {
        if (this.longLocations.containsKey(entry)) {
            return this.longLocations.get(entry);
        }
        short s = this.count;
        this.count = (short)(s + 1);
        short index = s;
        this.count = (short)(this.count + 1);
        this.constPoolSize = (short)(this.constPoolSize + 2);
        this.entries.put(index, new LongEntry(entry));
        this.longLocations.put(entry, index);
        return index;
    }

    public short addDoubleEntry(double entry) {
        if (this.doubleLocations.containsKey(entry)) {
            return this.doubleLocations.get(entry);
        }
        short s = this.count;
        this.count = (short)(s + 1);
        short index = s;
        this.count = (short)(this.count + 1);
        this.constPoolSize = (short)(this.constPoolSize + 2);
        this.entries.put(index, new DoubleEntry(entry));
        this.doubleLocations.put(entry, index);
        return index;
    }

    public short addNameAndTypeEntry(String name, String type) {
        NameAndType typeInfo = new NameAndType(name, type);
        if (this.nameAndTypeLocations.containsKey(typeInfo)) {
            return this.nameAndTypeLocations.get(typeInfo);
        }
        short nameIndex = this.addUtf8Entry(name);
        short typeIndex = this.addUtf8Entry(type);
        short s = this.count;
        this.count = (short)(s + 1);
        short index = s;
        this.constPoolSize = (short)(this.constPoolSize + 1);
        this.entries.put(index, new NameAndTypeEntry(nameIndex, typeIndex));
        this.nameAndTypeLocations.put(typeInfo, index);
        return index;
    }

    public short addFieldEntry(String className, String fieldName, String fieldType) {
        NameAndType nameAndType = new NameAndType(fieldName, fieldType);
        MemberInfo field = new MemberInfo(className, nameAndType);
        if (this.fieldLocations.containsKey(field)) {
            return this.fieldLocations.get(field);
        }
        short nameAndTypeIndex = this.addNameAndTypeEntry(fieldName, fieldType);
        short classIndex = this.addClassEntry(className);
        short s = this.count;
        this.count = (short)(s + 1);
        short index = s;
        this.constPoolSize = (short)(this.constPoolSize + 1);
        this.entries.put(index, new FieldRefEntry(classIndex, nameAndTypeIndex));
        this.fieldLocations.put(field, index);
        return index;
    }

    public short addMethodEntry(String className, String methodName, String descriptor) {
        NameAndType nameAndType = new NameAndType(methodName, descriptor);
        MemberInfo method = new MemberInfo(className, nameAndType);
        if (this.methodLocations.containsKey(method)) {
            return this.methodLocations.get(method);
        }
        short nameAndTypeIndex = this.addNameAndTypeEntry(methodName, descriptor);
        short classIndex = this.addClassEntry(className);
        short s = this.count;
        this.count = (short)(s + 1);
        short index = s;
        this.constPoolSize = (short)(this.constPoolSize + 1);
        this.entries.put(index, new MethodRefEntry(classIndex, nameAndTypeIndex));
        this.methodLocations.put(method, index);
        return index;
    }

    public short addInterfaceMethodEntry(String className, String methodName, String descriptor) {
        NameAndType nameAndType = new NameAndType(methodName, descriptor);
        MemberInfo method = new MemberInfo(className, nameAndType);
        if (this.interfaceMethodLocations.containsKey(method)) {
            return this.interfaceMethodLocations.get(method);
        }
        short nameAndTypeIndex = this.addNameAndTypeEntry(methodName, descriptor);
        short classIndex = this.addClassEntry(className);
        short s = this.count;
        this.count = (short)(s + 1);
        short index = s;
        this.constPoolSize = (short)(this.constPoolSize + 1);
        this.entries.put(index, new InterfaceMethodRefEntry(classIndex, nameAndTypeIndex));
        this.interfaceMethodLocations.put(method, index);
        return index;
    }

    @Override
    public void write(ByteArrayDataOutputStream stream) throws IOException {
        stream.writeShort(this.constPoolSize);
        for (Map.Entry<Short, ConstPoolEntry> entry : this.entries.entrySet()) {
            entry.getValue().write(stream);
        }
    }

    private static class MemberInfo {
        private final String className;
        private final NameAndType nameAndType;

        public MemberInfo(String className, NameAndType nameAndType) {
            this.className = className;
            this.nameAndType = nameAndType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            result = 31 * result + (this.nameAndType == null ? 0 : this.nameAndType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MemberInfo other = (MemberInfo)obj;
            if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                return false;
            }
            return !(this.nameAndType == null ? other.nameAndType != null : !this.nameAndType.equals(other.nameAndType));
        }
    }

    private static final class NameAndType {
        private final String name;
        private final String type;

        public NameAndType(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NameAndType other = (NameAndType)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

