/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;

public class SignatureBuilder {
    public static String fieldAttribute(Type type) {
        StringBuilder builder = new StringBuilder();
        SignatureBuilder.fieldAttribute(type, builder);
        return builder.toString();
    }

    private static void fieldAttribute(Type type, StringBuilder builder) {
        if (type instanceof Class) {
            SignatureBuilder.classType((Class)type, builder);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            SignatureBuilder.parametizedType(ptype, builder);
        } else if (type instanceof WildcardType) {
            WildcardType ptype = (WildcardType)type;
            SignatureBuilder.wildcardType(ptype, builder);
        }
    }

    private static void wildcardType(WildcardType type, StringBuilder builder) {
        builder.append('*');
    }

    public static void parametizedType(ParameterizedType type, StringBuilder builder) {
        SignatureBuilder.fieldAttribute(type.getRawType(), builder);
        builder.append('<');
        for (Type t : type.getActualTypeArguments()) {
            SignatureBuilder.fieldAttribute(t, builder);
            builder.append(';');
        }
        builder.append(">;");
    }

    private static void classType(Class<?> clazz, StringBuilder builder) {
        if (clazz.isMemberClass()) {
            SignatureBuilder.classType(clazz.getDeclaringClass(), builder);
            builder.append('.');
            builder.append(clazz.getSimpleName());
        } else {
            builder.append("L");
            builder.append(clazz.getName().replace('.', '/'));
        }
    }

    private SignatureBuilder() {
    }
}

