/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.modified;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.deployers.vfs.spi.structure.modified.AbstractStructureCache;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStructureCache<T>
extends AbstractStructureCache<T> {
    private Map<VirtualFile, T> map = new ConcurrentHashMap<VirtualFile, T>();

    @Override
    public void initializeCache(VirtualFile root) {
    }

    @Override
    public T putCacheValue(VirtualFile file, T value) {
        return this.map.put(file, value);
    }

    @Override
    public T getCacheValue(VirtualFile file) {
        return this.map.get(file);
    }

    @Override
    public List<VirtualFile> getLeaves(VirtualFile file, VirtualFileFilter filter) {
        ArrayList<VirtualFile> result = null;
        for (VirtualFile key : this.map.keySet()) {
            VirtualFile parent = key.getParent();
            if (parent == null || !parent.equals((Object)file) || filter != null && !filter.accepts(key)) continue;
            if (result == null) {
                result = new ArrayList<VirtualFile>();
            }
            result.add(key);
        }
        if (result != null) {
            return result;
        }
        return this.map.containsKey(file) ? Collections.emptyList() : null;
    }

    @Override
    public void invalidateCache(VirtualFile file) {
        this.removeCache(file);
    }

    @Override
    public void removeCache(VirtualFile file) {
        Iterator<Map.Entry<VirtualFile, T>> iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<VirtualFile, T> entry = iter.next();
            if (!this.isAncestorOrEquals(file, entry.getKey())) continue;
            iter.remove();
        }
    }

    @Override
    public void removeCache(VirtualFile root, String path) {
        Iterator<Map.Entry<VirtualFile, T>> iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<VirtualFile, T> entry = iter.next();
            VirtualFile key = entry.getKey();
            if (!this.isAncestorOrEquals(root, key) || !key.getPathName().startsWith(path)) continue;
            iter.remove();
        }
    }

    protected boolean isAncestorOrEquals(VirtualFile ref, VirtualFile file) {
        while (file != null) {
            if (file.equals((Object)ref)) {
                return true;
            }
            file = file.getParent();
        }
        return false;
    }

    @Override
    public void flush() {
        this.map.clear();
    }
}

