/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.aop;

import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.InstanceAdvisorDelegate;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.interceptors.container.ManagedObjectAdvisor;
import org.jboss.logging.Logger;

public class ManagedObjectAdvisorInstanceInterceptor
implements Interceptor {
    Logger log = Logger.getLogger(ManagedObjectAdvisorInstanceInterceptor.class);
    private Map<Object, InstanceAdvisorDelegate> instanceAdvisorDelegates;

    public String getName() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        ManagedObjectAdvisor advisor = (ManagedObjectAdvisor)invocation.getAdvisor();
        InstanceAdvisorDelegate delegate = this.getInstanceAdvisorDelegate(invocation.getTargetObject(), (Advisor)advisor, advisor);
        try {
            this.log.debug((Object)("Pushing ia delegate " + delegate + " for " + invocation.getTargetObject()));
            advisor.pushThreadedInstanceAdvisorDelegate(delegate);
            Object object = invocation.invokeNext();
            return object;
        }
        finally {
            advisor.popThreadedInstanceAdvisorDelegate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstanceAdvisorDelegate getInstanceAdvisorDelegate(Object target, Advisor advisor, InstanceAdvisor instanceAdvisor) {
        if (this.instanceAdvisorDelegates == null) {
            this.instanceAdvisorDelegates = new WeakHashMap<Object, InstanceAdvisorDelegate>();
        }
        if (target == null) {
            throw new RuntimeException("Attempt to get instance advisor without having an instance");
        }
        InstanceAdvisorDelegate instanceAdvisorDelegate = this.instanceAdvisorDelegates.get(target);
        if (instanceAdvisorDelegate != null) {
            return instanceAdvisorDelegate;
        }
        ManagedObjectAdvisorInstanceInterceptor managedObjectAdvisorInstanceInterceptor = this;
        synchronized (managedObjectAdvisorInstanceInterceptor) {
            if (instanceAdvisorDelegate == null) {
                instanceAdvisorDelegate = new InstanceAdvisorDelegate(advisor, instanceAdvisor);
                instanceAdvisorDelegate.initialize();
                this.instanceAdvisorDelegates.put(target, instanceAdvisorDelegate);
            }
        }
        return instanceAdvisorDelegate;
    }
}

