/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.List;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.Domain;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.InstanceAdvisorDelegate;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.annotation.AnnotationRepository;
import org.jboss.aop.introduction.AnnotationIntroduction;
import org.jboss.aop.joinpoint.ConstructorJoinpoint;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.ejb3.interceptors.ManagedObject;
import org.jboss.ejb3.interceptors.aop.ExtendedAdvisor;
import org.jboss.ejb3.interceptors.container.AbstractContainer;
import org.jboss.ejb3.interceptors.container.DummyMetaData;
import org.jboss.ejb3.interceptors.util.ThreadLocalStack;
import org.jboss.ejb3.metadata.annotation.ExtendedAnnotationRepository;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedObjectAdvisor<T, C extends AbstractContainer<T, C>>
extends ClassAdvisor
implements ExtendedAdvisor,
InstanceAdvisor {
    private static final Logger log = Logger.getLogger(ManagedObjectAdvisor.class);
    private C container;
    private InstanceAdvisorDelegate instanceAdvisorDelegate;
    private ThreadLocalStack<InstanceAdvisorDelegate> threadedInstanceAdvisorDelegateStack;

    protected ManagedObjectAdvisor(C container, String name, AspectManager manager) {
        this(container, name, manager, null);
    }

    protected ManagedObjectAdvisor(C container, String name, AspectManager manager, AnnotationRepository pAnnotations) {
        super(name, manager);
        assert (container != null) : "container is null";
        this.container = container;
        if (pAnnotations != null) {
            this.setMetadata(new DummyMetaData());
            this.annotations = pAnnotations;
        }
        ManagedObject annotation = new ManagedObject(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return ManagedObject.class;
            }
        };
        this.annotations.addClassAnnotation(ManagedObject.class, (Object)annotation);
    }

    public boolean chainOverridingForInheritedMethods() {
        return true;
    }

    protected void createInterceptorChain(InterceptorFactory[] factories, ArrayList newinterceptors, Joinpoint joinpoint) {
        if (joinpoint instanceof ConstructorJoinpoint) {
            for (InterceptorFactory factory : factories) {
                AspectDefinition def = factory.getAspect();
                if (def.getScope() != Scope.PER_JOINPOINT) continue;
                newinterceptors.add(def.getFactory().createPerJoinpoint((Advisor)this, (InstanceAdvisor)this, joinpoint));
                return;
            }
        }
        super.createInterceptorChain(factories, newinterceptors, joinpoint);
    }

    private void deployAnnotationIntroduction(AnnotationIntroduction introduction) {
        log.debug((Object)("deploy annotation introduction " + introduction));
        this.deployAnnotationOverride(introduction);
    }

    private void deployAnnotationIntroductions() {
        List annotationIntroductions = this.getManager().getAnnotationIntroductions();
        if (annotationIntroductions != null) {
            for (AnnotationIntroduction ai : annotationIntroductions) {
                this.deployAnnotationIntroduction(ai);
            }
        }
    }

    public C getContainer() {
        return this.container;
    }

    protected void initialize(Class<?> beanClass) {
        assert (beanClass != null) : "beanClass is null";
        this.attachClass(beanClass);
    }

    protected void rebindClassMetaData() {
        super.rebindClassMetaData();
        this.deployAnnotationIntroductions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InstanceAdvisorDelegate getInstanceAdvisorDelegate() {
        InstanceAdvisorDelegate delegate;
        if (this.threadedInstanceAdvisorDelegateStack != null && (delegate = this.threadedInstanceAdvisorDelegateStack.get()) != null) {
            return delegate;
        }
        if (this.instanceAdvisorDelegate != null) {
            return this.instanceAdvisorDelegate;
        }
        ManagedObjectAdvisor managedObjectAdvisor = this;
        synchronized (managedObjectAdvisor) {
            if (this.instanceAdvisorDelegate == null) {
                this.instanceAdvisorDelegate = new InstanceAdvisorDelegate((Advisor)this, (InstanceAdvisor)this);
                this.instanceAdvisorDelegate.initialize();
            }
        }
        return this.instanceAdvisorDelegate;
    }

    public final void pushThreadedInstanceAdvisorDelegate(InstanceAdvisorDelegate delegate) {
        if (this.threadedInstanceAdvisorDelegateStack == null) {
            this.threadedInstanceAdvisorDelegateStack = new ThreadLocalStack();
        }
        this.threadedInstanceAdvisorDelegateStack.push(delegate);
    }

    public final InstanceAdvisorDelegate popThreadedInstanceAdvisorDelegate() {
        if (this.threadedInstanceAdvisorDelegateStack == null) {
            return null;
        }
        return this.threadedInstanceAdvisorDelegateStack.pop();
    }

    public void appendInterceptor(Interceptor interceptor) {
        throw new RuntimeException("NYI");
    }

    public void appendInterceptor(int index, Interceptor interceptor) {
        throw new RuntimeException("NYI");
    }

    public void appendInterceptorStack(String stackName) {
        throw new RuntimeException("NYI");
    }

    public Domain getDomain() {
        throw new RuntimeException("NYI");
    }

    public Object getInstance() {
        throw new RuntimeException("NYI");
    }

    public Interceptor[] getInterceptors() {
        throw new RuntimeException("NYI");
    }

    public Interceptor[] getInterceptors(Interceptor[] baseChain) {
        throw new RuntimeException("NYI");
    }

    public SimpleMetaData getMetaData() {
        return this.getInstanceAdvisorDelegate().getMetaData();
    }

    public Object getPerInstanceAspect(String aspectName) {
        return this.getInstanceAdvisorDelegate().getPerInstanceAspect(aspectName);
    }

    public Object getPerInstanceAspect(AspectDefinition def) {
        return this.getInstanceAdvisorDelegate().getPerInstanceAspect(def);
    }

    public Object getPerInstanceJoinpointAspect(Joinpoint joinpoint, AspectDefinition def) {
        return this.getInstanceAdvisorDelegate().getPerInstanceJoinpointAspect(joinpoint, def);
    }

    public boolean hasInterceptors() {
        throw new RuntimeException("NYI");
    }

    public void insertInterceptor(Interceptor interceptor) {
        throw new RuntimeException("NYI");
    }

    public void insertInterceptor(int index, Interceptor interceptor) {
        throw new RuntimeException("NYI");
    }

    public void insertInterceptorStack(String stackName) {
        throw new RuntimeException("NYI");
    }

    public void removeInterceptor(String name) {
        throw new RuntimeException("NYI");
    }

    public void removeInterceptorStack(String name) {
        throw new RuntimeException("NYI");
    }

    @Override
    public boolean isAnnotationPresent(Class<?> cls, Class<? extends Annotation> annotationType) {
        if (this.annotations instanceof ExtendedAnnotationRepository && ((ExtendedAnnotationRepository)this.annotations).hasAnnotation(cls, annotationType)) {
            return true;
        }
        return cls.isAnnotationPresent(annotationType);
    }

    @Override
    public boolean isAnnotationPresent(Class<?> cls, Member member, Class<? extends Annotation> annotationType) {
        if (this.annotations instanceof ExtendedAnnotationRepository && ((ExtendedAnnotationRepository)this.annotations).hasAnnotation(cls, member, annotationType)) {
            return true;
        }
        return member instanceof AnnotatedElement && ((AnnotatedElement)((Object)member)).isAnnotationPresent(annotationType);
    }

    @Override
    public <A extends Annotation> A resolveAnnotation(Class<?> cls, Class<A> annotationType) {
        Annotation annotation = null;
        if (this.annotations instanceof ExtendedAnnotationRepository) {
            annotation = ((ExtendedAnnotationRepository)this.annotations).resolveAnnotation(cls, annotationType);
        }
        if (annotation == null) {
            annotation = (Annotation)cls.getAnnotation(annotationType);
        }
        return (A)annotation;
    }

    @Override
    public <A extends Annotation> A resolveAnnotation(Class<?> cls, Member member, Class<A> annotationType) {
        Annotation annotation = null;
        if (this.annotations instanceof ExtendedAnnotationRepository) {
            annotation = ((ExtendedAnnotationRepository)this.annotations).resolveAnnotation(cls, member, annotationType);
        }
        if (annotation == null && member instanceof AnnotatedElement) {
            annotation = ((AnnotatedElement)((Object)member)).getAnnotation(annotationType);
        }
        return (A)annotation;
    }
}

