/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import java.util.TimeZone;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.api.CallbackContext;
import org.apache.cordova.api.CordovaInterface;
import org.apache.cordova.api.CordovaPlugin;
import org.apache.cordova.api.LOG;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Device
extends CordovaPlugin {
    public static final String TAG = "Device";
    public static String cordovaVersion = "2.8.0rc1";
    public static String platform = "Android";
    public static String uuid;
    BroadcastReceiver telephonyReceiver = null;

    public void initialize(CordovaInterface cordova, CordovaWebView webView) {
        super.initialize(cordova, webView);
        uuid = this.getUuid();
        this.initTelephonyReceiver();
    }

    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        if (!action.equals("getDeviceInfo")) {
            return false;
        }
        JSONObject r = new JSONObject();
        r.put("uuid", (Object)uuid);
        r.put("version", (Object)this.getOSVersion());
        r.put("platform", (Object)platform);
        r.put("cordova", (Object)cordovaVersion);
        r.put("model", (Object)this.getModel());
        callbackContext.success(r);
        return true;
    }

    public void onDestroy() {
        this.cordova.getActivity().unregisterReceiver(this.telephonyReceiver);
    }

    private void initTelephonyReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PHONE_STATE");
        this.telephonyReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent != null && intent.getAction().equals("android.intent.action.PHONE_STATE") && intent.hasExtra("state")) {
                    String extraData = intent.getStringExtra("state");
                    if (extraData.equals(TelephonyManager.EXTRA_STATE_RINGING)) {
                        LOG.i(Device.TAG, "Telephone RINGING");
                        Device.this.webView.postMessage("telephone", "ringing");
                    } else if (extraData.equals(TelephonyManager.EXTRA_STATE_OFFHOOK)) {
                        LOG.i(Device.TAG, "Telephone OFFHOOK");
                        Device.this.webView.postMessage("telephone", "offhook");
                    } else if (extraData.equals(TelephonyManager.EXTRA_STATE_IDLE)) {
                        LOG.i(Device.TAG, "Telephone IDLE");
                        Device.this.webView.postMessage("telephone", "idle");
                    }
                }
            }
        };
        this.cordova.getActivity().registerReceiver(this.telephonyReceiver, intentFilter);
    }

    public String getPlatform() {
        return platform;
    }

    public String getUuid() {
        String uuid = Settings.Secure.getString((ContentResolver)this.cordova.getActivity().getContentResolver(), (String)"android_id");
        return uuid;
    }

    public String getCordovaVersion() {
        return cordovaVersion;
    }

    public String getModel() {
        String model = Build.MODEL;
        return model;
    }

    public String getProductName() {
        String productname = Build.PRODUCT;
        return productname;
    }

    public String getOSVersion() {
        String osversion = Build.VERSION.RELEASE;
        return osversion;
    }

    public String getSDKVersion() {
        String sdkversion = Build.VERSION.SDK;
        return sdkversion;
    }

    public String getTimeZoneID() {
        TimeZone tz = TimeZone.getDefault();
        return tz.getID();
    }
}

