/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.cordova.Config;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.api.CallbackContext;
import org.apache.cordova.api.CordovaPlugin;
import org.apache.cordova.api.LOG;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressLint(value={"SetJavaScriptEnabled"})
public class InAppBrowser
extends CordovaPlugin {
    private static final String NULL = "null";
    protected static final String LOG_TAG = "InAppBrowser";
    private static final String SELF = "_self";
    private static final String SYSTEM = "_system";
    private static final String LOCATION = "location";
    private static final String EXIT_EVENT = "exit";
    private static final String LOAD_START_EVENT = "loadstart";
    private static final String LOAD_STOP_EVENT = "loadstop";
    private static final String LOAD_ERROR_EVENT = "loaderror";
    private static final String CLOSE_BUTTON_CAPTION = "closebuttoncaption";
    private long MAX_QUOTA = 0x6400000L;
    private Dialog dialog;
    private WebView inAppWebView;
    private EditText edittext;
    private boolean showLocationBar = true;
    private CallbackContext callbackContext;
    private String buttonLabel = "Done";

    @Override
    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        block20: {
            try {
                if (action.equals("open")) {
                    this.callbackContext = callbackContext;
                    String url = args.getString(0);
                    String target = args.optString(1);
                    if (target == null || target.equals("") || target.equals(NULL)) {
                        target = SELF;
                    }
                    HashMap<String, Boolean> features = this.parseFeature(args.optString(2));
                    Log.d((String)LOG_TAG, (String)("target = " + target));
                    url = this.updateUrl(url);
                    String result = "";
                    if (SELF.equals(target)) {
                        Log.d((String)LOG_TAG, (String)"in self");
                        if (url.startsWith("file://") || url.startsWith("javascript:") || Config.isUrlWhiteListed(url)) {
                            this.webView.loadUrl(url);
                        } else if (url.startsWith("tel:")) {
                            try {
                                Intent intent = new Intent("android.intent.action.DIAL");
                                intent.setData(Uri.parse((String)url));
                                this.cordova.getActivity().startActivity(intent);
                            }
                            catch (ActivityNotFoundException e) {
                                LOG.e(LOG_TAG, "Error dialing " + url + ": " + e.toString());
                            }
                        } else {
                            result = this.showWebPage(url, features);
                        }
                    } else if (SYSTEM.equals(target)) {
                        Log.d((String)LOG_TAG, (String)"in system");
                        result = this.openExternal(url);
                    } else {
                        Log.d((String)LOG_TAG, (String)"in blank");
                        result = this.showWebPage(url, features);
                    }
                    PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, result);
                    pluginResult.setKeepCallback(true);
                    this.callbackContext.sendPluginResult(pluginResult);
                    break block20;
                }
                if (action.equals("close")) {
                    this.closeDialog();
                    this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK));
                    break block20;
                }
                if (action.equals("injectScriptCode")) {
                    String jsWrapper = null;
                    if (args.getBoolean(1)) {
                        jsWrapper = String.format("prompt(JSON.stringify([eval(%%s)]), 'gap-iab://%s')", callbackContext.getCallbackId());
                    }
                    this.injectDeferredObject(args.getString(0), jsWrapper);
                    break block20;
                }
                if (action.equals("injectScriptFile")) {
                    String jsWrapper = args.getBoolean(1) ? String.format("(function(d) { var c = d.createElement('script'); c.src = %%s; c.onload = function() { prompt('', 'gap-iab://%s'); }; d.body.appendChild(c); })(document)", callbackContext.getCallbackId()) : "(function(d) { var c = d.createElement('script'); c.src = %s; d.body.appendChild(c); })(document)";
                    this.injectDeferredObject(args.getString(0), jsWrapper);
                    break block20;
                }
                if (action.equals("injectStyleCode")) {
                    String jsWrapper = args.getBoolean(1) ? String.format("(function(d) { var c = d.createElement('style'); c.innerHTML = %%s; d.body.appendChild(c); prompt('', 'gap-iab://%s');})(document)", callbackContext.getCallbackId()) : "(function(d) { var c = d.createElement('style'); c.innerHTML = %s; d.body.appendChild(c); })(document)";
                    this.injectDeferredObject(args.getString(0), jsWrapper);
                    break block20;
                }
                if (action.equals("injectStyleFile")) {
                    String jsWrapper = args.getBoolean(1) ? String.format("(function(d) { var c = d.createElement('link'); c.rel='stylesheet'; c.type='text/css'; c.href = %%s; d.head.appendChild(c); prompt('', 'gap-iab://%s');})(document)", callbackContext.getCallbackId()) : "(function(d) { var c = d.createElement('link'); c.rel='stylesheet'; c.type='text/css'; c.href = %s; d.head.appendChild(c); })(document)";
                    this.injectDeferredObject(args.getString(0), jsWrapper);
                    break block20;
                }
                return false;
            }
            catch (JSONException e) {
                this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.JSON_EXCEPTION));
            }
        }
        return true;
    }

    private void injectDeferredObject(String source, String jsWrapper) {
        String scriptToInject;
        if (jsWrapper != null) {
            JSONArray jsonEsc = new JSONArray();
            jsonEsc.put((Object)source);
            String jsonRepr = jsonEsc.toString();
            String jsonSourceString = jsonRepr.substring(1, jsonRepr.length() - 1);
            scriptToInject = String.format(jsWrapper, jsonSourceString);
        } else {
            scriptToInject = source;
        }
        this.inAppWebView.loadUrl("javascript:" + scriptToInject);
    }

    private HashMap<String, Boolean> parseFeature(String optString) {
        if (optString.equals(NULL)) {
            return null;
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        StringTokenizer features = new StringTokenizer(optString, ",");
        while (features.hasMoreElements()) {
            StringTokenizer option = new StringTokenizer(features.nextToken(), "=");
            if (!option.hasMoreElements()) continue;
            String key = option.nextToken();
            if (key.equalsIgnoreCase(CLOSE_BUTTON_CAPTION)) {
                this.buttonLabel = option.nextToken();
                continue;
            }
            Boolean value = option.nextToken().equals("no") ? Boolean.FALSE : Boolean.TRUE;
            map.put(key, value);
        }
        return map;
    }

    private String updateUrl(String url) {
        Uri newUrl = Uri.parse((String)url);
        if (newUrl.isRelative()) {
            url = this.webView.getUrl().substring(0, this.webView.getUrl().lastIndexOf("/") + 1) + url;
        }
        return url;
    }

    public String openExternal(String url) {
        try {
            Intent intent = null;
            intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            this.cordova.getActivity().startActivity(intent);
            return "";
        }
        catch (ActivityNotFoundException e) {
            Log.d((String)LOG_TAG, (String)("InAppBrowser: Error loading url " + url + ":" + e.toString()));
            return e.toString();
        }
    }

    private void closeDialog() {
        try {
            this.inAppWebView.loadUrl("about:blank");
            JSONObject obj = new JSONObject();
            obj.put("type", (Object)EXIT_EVENT);
            this.sendUpdate(obj, false);
        }
        catch (JSONException ex) {
            Log.d((String)LOG_TAG, (String)"Should never happen");
        }
        if (this.dialog != null) {
            this.dialog.dismiss();
        }
    }

    private void goBack() {
        if (this.inAppWebView.canGoBack()) {
            this.inAppWebView.goBack();
        }
    }

    private void goForward() {
        if (this.inAppWebView.canGoForward()) {
            this.inAppWebView.goForward();
        }
    }

    private void navigate(String url) {
        InputMethodManager imm = (InputMethodManager)this.cordova.getActivity().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.edittext.getWindowToken(), 0);
        if (!url.startsWith("http") && !url.startsWith("file:")) {
            this.inAppWebView.loadUrl("http://" + url);
        } else {
            this.inAppWebView.loadUrl(url);
        }
        this.inAppWebView.requestFocus();
    }

    private boolean getShowLocationBar() {
        return this.showLocationBar;
    }

    public String showWebPage(final String url, HashMap<String, Boolean> features) {
        Boolean show;
        this.showLocationBar = true;
        if (features != null && (show = features.get(LOCATION)) != null) {
            this.showLocationBar = show;
        }
        final CordovaWebView thatWebView = this.webView;
        Runnable runnable = new Runnable(){

            private int dpToPixels(int dipValue) {
                int value = (int)TypedValue.applyDimension((int)1, (float)dipValue, (DisplayMetrics)InAppBrowser.this.cordova.getActivity().getResources().getDisplayMetrics());
                return value;
            }

            public void run() {
                boolean enableDatabase;
                InAppBrowser.this.dialog = new Dialog((Context)InAppBrowser.this.cordova.getActivity(), 16973830);
                ((InAppBrowser)InAppBrowser.this).dialog.getWindow().getAttributes().windowAnimations = 16973826;
                InAppBrowser.this.dialog.requestWindowFeature(1);
                InAppBrowser.this.dialog.setCancelable(true);
                InAppBrowser.this.dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                    public void onDismiss(DialogInterface dialog) {
                        try {
                            JSONObject obj = new JSONObject();
                            obj.put("type", (Object)InAppBrowser.EXIT_EVENT);
                            InAppBrowser.this.sendUpdate(obj, false);
                        }
                        catch (JSONException e) {
                            Log.d((String)InAppBrowser.LOG_TAG, (String)"Should never happen");
                        }
                    }
                });
                LinearLayout main = new LinearLayout((Context)InAppBrowser.this.cordova.getActivity());
                main.setOrientation(1);
                RelativeLayout toolbar = new RelativeLayout((Context)InAppBrowser.this.cordova.getActivity());
                toolbar.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, this.dpToPixels(44)));
                toolbar.setPadding(this.dpToPixels(2), this.dpToPixels(2), this.dpToPixels(2), this.dpToPixels(2));
                toolbar.setHorizontalGravity(3);
                toolbar.setVerticalGravity(48);
                RelativeLayout actionButtonContainer = new RelativeLayout((Context)InAppBrowser.this.cordova.getActivity());
                actionButtonContainer.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
                actionButtonContainer.setHorizontalGravity(3);
                actionButtonContainer.setVerticalGravity(16);
                actionButtonContainer.setId(1);
                Button back = new Button((Context)InAppBrowser.this.cordova.getActivity());
                RelativeLayout.LayoutParams backLayoutParams = new RelativeLayout.LayoutParams(-2, -1);
                backLayoutParams.addRule(5);
                back.setLayoutParams((ViewGroup.LayoutParams)backLayoutParams);
                back.setContentDescription((CharSequence)"Back Button");
                back.setId(2);
                back.setText((CharSequence)"<");
                back.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        InAppBrowser.this.goBack();
                    }
                });
                Button forward = new Button((Context)InAppBrowser.this.cordova.getActivity());
                RelativeLayout.LayoutParams forwardLayoutParams = new RelativeLayout.LayoutParams(-2, -1);
                forwardLayoutParams.addRule(1, 2);
                forward.setLayoutParams((ViewGroup.LayoutParams)forwardLayoutParams);
                forward.setContentDescription((CharSequence)"Forward Button");
                forward.setId(3);
                forward.setText((CharSequence)">");
                forward.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        InAppBrowser.this.goForward();
                    }
                });
                InAppBrowser.this.edittext = new EditText((Context)InAppBrowser.this.cordova.getActivity());
                RelativeLayout.LayoutParams textLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
                textLayoutParams.addRule(1, 1);
                textLayoutParams.addRule(0, 5);
                InAppBrowser.this.edittext.setLayoutParams((ViewGroup.LayoutParams)textLayoutParams);
                InAppBrowser.this.edittext.setId(4);
                InAppBrowser.this.edittext.setSingleLine(true);
                InAppBrowser.this.edittext.setText((CharSequence)url);
                InAppBrowser.this.edittext.setInputType(16);
                InAppBrowser.this.edittext.setImeOptions(2);
                InAppBrowser.this.edittext.setInputType(0);
                InAppBrowser.this.edittext.setOnKeyListener(new View.OnKeyListener(){

                    public boolean onKey(View v, int keyCode, KeyEvent event) {
                        if (event.getAction() == 0 && keyCode == 66) {
                            InAppBrowser.this.navigate(InAppBrowser.this.edittext.getText().toString());
                            return true;
                        }
                        return false;
                    }
                });
                Button close = new Button((Context)InAppBrowser.this.cordova.getActivity());
                RelativeLayout.LayoutParams closeLayoutParams = new RelativeLayout.LayoutParams(-2, -1);
                closeLayoutParams.addRule(11);
                close.setLayoutParams((ViewGroup.LayoutParams)closeLayoutParams);
                forward.setContentDescription((CharSequence)"Close Button");
                close.setId(5);
                close.setText((CharSequence)InAppBrowser.this.buttonLabel);
                close.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        InAppBrowser.this.closeDialog();
                    }
                });
                InAppBrowser.this.inAppWebView = new WebView((Context)InAppBrowser.this.cordova.getActivity());
                InAppBrowser.this.inAppWebView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
                InAppBrowser.this.inAppWebView.setWebChromeClient((WebChromeClient)new InAppChromeClient(thatWebView));
                InAppBrowserClient client = new InAppBrowserClient(thatWebView, InAppBrowser.this.edittext);
                InAppBrowser.this.inAppWebView.setWebViewClient((WebViewClient)client);
                WebSettings settings = InAppBrowser.this.inAppWebView.getSettings();
                settings.setJavaScriptEnabled(true);
                settings.setJavaScriptCanOpenWindowsAutomatically(true);
                settings.setBuiltInZoomControls(true);
                settings.setPluginsEnabled(true);
                Bundle appSettings = InAppBrowser.this.cordova.getActivity().getIntent().getExtras();
                boolean bl = enableDatabase = appSettings == null ? true : appSettings.getBoolean("InAppBrowserStorageEnabled", true);
                if (enableDatabase) {
                    String databasePath = InAppBrowser.this.cordova.getActivity().getApplicationContext().getDir("inAppBrowserDB", 0).getPath();
                    settings.setDatabasePath(databasePath);
                    settings.setDatabaseEnabled(true);
                }
                settings.setDomStorageEnabled(true);
                InAppBrowser.this.inAppWebView.loadUrl(url);
                InAppBrowser.this.inAppWebView.setId(6);
                InAppBrowser.this.inAppWebView.getSettings().setLoadWithOverviewMode(true);
                InAppBrowser.this.inAppWebView.getSettings().setUseWideViewPort(true);
                InAppBrowser.this.inAppWebView.requestFocus();
                InAppBrowser.this.inAppWebView.requestFocusFromTouch();
                actionButtonContainer.addView((View)back);
                actionButtonContainer.addView((View)forward);
                toolbar.addView((View)actionButtonContainer);
                toolbar.addView((View)InAppBrowser.this.edittext);
                toolbar.addView((View)close);
                if (InAppBrowser.this.getShowLocationBar()) {
                    main.addView((View)toolbar);
                }
                main.addView((View)InAppBrowser.this.inAppWebView);
                WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
                lp.copyFrom(InAppBrowser.this.dialog.getWindow().getAttributes());
                lp.width = -1;
                lp.height = -1;
                InAppBrowser.this.dialog.setContentView((View)main);
                InAppBrowser.this.dialog.show();
                InAppBrowser.this.dialog.getWindow().setAttributes(lp);
            }
        };
        this.cordova.getActivity().runOnUiThread(runnable);
        return "";
    }

    private void sendUpdate(JSONObject obj, boolean keepCallback) {
        this.sendUpdate(obj, keepCallback, PluginResult.Status.OK);
    }

    private void sendUpdate(JSONObject obj, boolean keepCallback, PluginResult.Status status) {
        PluginResult result = new PluginResult(status, obj);
        result.setKeepCallback(keepCallback);
        this.callbackContext.sendPluginResult(result);
    }

    public class InAppBrowserClient
    extends WebViewClient {
        EditText edittext;
        CordovaWebView webView;

        public InAppBrowserClient(CordovaWebView webView, EditText mEditText) {
            this.webView = webView;
            this.edittext = mEditText;
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            Intent intent;
            super.onPageStarted(view, url, favicon);
            String newloc = "";
            if (url.startsWith("http:") || url.startsWith("https:") || url.startsWith("file:")) {
                newloc = url;
            } else if (url.startsWith("tel:")) {
                try {
                    intent = new Intent("android.intent.action.DIAL");
                    intent.setData(Uri.parse((String)url));
                    InAppBrowser.this.cordova.getActivity().startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    LOG.e(InAppBrowser.LOG_TAG, "Error dialing " + url + ": " + e.toString());
                }
            } else if (url.startsWith("geo:") || url.startsWith("mailto:") || url.startsWith("market:")) {
                try {
                    intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    InAppBrowser.this.cordova.getActivity().startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    LOG.e(InAppBrowser.LOG_TAG, "Error with " + url + ": " + e.toString());
                }
            } else if (url.startsWith("sms:")) {
                try {
                    intent = new Intent("android.intent.action.VIEW");
                    String address = null;
                    int parmIndex = url.indexOf(63);
                    if (parmIndex == -1) {
                        address = url.substring(4);
                    } else {
                        address = url.substring(4, parmIndex);
                        Uri uri = Uri.parse((String)url);
                        String query = uri.getQuery();
                        if (query != null && query.startsWith("body=")) {
                            intent.putExtra("sms_body", query.substring(5));
                        }
                    }
                    intent.setData(Uri.parse((String)("sms:" + address)));
                    intent.putExtra("address", address);
                    intent.setType("vnd.android-dir/mms-sms");
                    InAppBrowser.this.cordova.getActivity().startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    LOG.e(InAppBrowser.LOG_TAG, "Error sending sms " + url + ":" + e.toString());
                }
            } else {
                newloc = "http://" + url;
            }
            if (!newloc.equals(this.edittext.getText().toString())) {
                this.edittext.setText((CharSequence)newloc);
            }
            try {
                JSONObject obj = new JSONObject();
                obj.put("type", (Object)InAppBrowser.LOAD_START_EVENT);
                obj.put("url", (Object)newloc);
                InAppBrowser.this.sendUpdate(obj, true);
            }
            catch (JSONException ex) {
                Log.d((String)InAppBrowser.LOG_TAG, (String)"Should never happen");
            }
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            try {
                JSONObject obj = new JSONObject();
                obj.put("type", (Object)InAppBrowser.LOAD_STOP_EVENT);
                obj.put("url", (Object)url);
                InAppBrowser.this.sendUpdate(obj, true);
            }
            catch (JSONException ex) {
                Log.d((String)InAppBrowser.LOG_TAG, (String)"Should never happen");
            }
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            try {
                JSONObject obj = new JSONObject();
                obj.put("type", (Object)InAppBrowser.LOAD_ERROR_EVENT);
                obj.put("url", (Object)failingUrl);
                obj.put("code", errorCode);
                obj.put("message", (Object)description);
                InAppBrowser.this.sendUpdate(obj, true, PluginResult.Status.ERROR);
            }
            catch (JSONException ex) {
                Log.d((String)InAppBrowser.LOG_TAG, (String)"Should never happen");
            }
        }
    }

    public class InAppChromeClient
    extends WebChromeClient {
        private CordovaWebView webView;

        public InAppChromeClient(CordovaWebView webView) {
            this.webView = webView;
        }

        public void onExceededDatabaseQuota(String url, String databaseIdentifier, long currentQuota, long estimatedSize, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
            LOG.d(InAppBrowser.LOG_TAG, "onExceededDatabaseQuota estimatedSize: %d  currentQuota: %d  totalUsedQuota: %d", estimatedSize, currentQuota, totalUsedQuota);
            if (estimatedSize < InAppBrowser.this.MAX_QUOTA) {
                long newQuota = estimatedSize;
                LOG.d(InAppBrowser.LOG_TAG, "calling quotaUpdater.updateQuota newQuota: %d", newQuota);
                quotaUpdater.updateQuota(newQuota);
            } else {
                quotaUpdater.updateQuota(currentQuota);
            }
        }

        public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
            super.onGeolocationPermissionsShowPrompt(origin, callback);
            callback.invoke(origin, true, false);
        }

        public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
            String scriptCallbackId;
            if (defaultValue != null && defaultValue.startsWith("gap-iab://") && (scriptCallbackId = defaultValue.substring(10)).startsWith(InAppBrowser.LOG_TAG)) {
                PluginResult scriptResult;
                if (message == null || message.length() == 0) {
                    scriptResult = new PluginResult(PluginResult.Status.OK, new JSONArray());
                } else {
                    try {
                        scriptResult = new PluginResult(PluginResult.Status.OK, new JSONArray(message));
                    }
                    catch (JSONException e) {
                        scriptResult = new PluginResult(PluginResult.Status.JSON_EXCEPTION, e.getMessage());
                    }
                }
                this.webView.sendPluginResult(scriptResult, scriptCallbackId);
                result.confirm("");
                return true;
            }
            return false;
        }
    }
}

