/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.rest.generation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageCollector {
    private Map<MessageType, List<String>> messages = new HashMap<MessageType, List<String>>();

    public void addErrorMessage(String message) {
        this.add(MessageType.ERROR, message);
    }

    public void addInformationMessage(String message) {
        this.add(MessageType.INFO, message);
    }

    public void addWarningMessage(String message) {
        this.add(MessageType.WARNING, message);
    }

    public List<String> getErrorMessages() {
        return this.get(MessageType.ERROR);
    }

    public List<String> getInformationMessages() {
        return this.get(MessageType.INFO);
    }

    public List<String> getWarningMessages() {
        return this.get(MessageType.WARNING);
    }

    private void add(MessageType type, String message) {
        List<String> list = this.messages.get((Object)type);
        if (list == null) {
            list = new ArrayList<String>();
            this.messages.put(type, list);
        }
        list.add(message);
    }

    private List<String> get(MessageType type) {
        List<String> list = this.messages.get((Object)type);
        return list == null ? Collections.emptyList() : list;
    }

    private static enum MessageType {
        ERROR,
        INFO,
        WARNING;

    }
}

