/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.util;

import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;

public class Commands {
    private static final Pattern WHITESPACES = Pattern.compile("\\W+");
    private static final Pattern COLONS = Pattern.compile("\\:");
    private static final Logger log = Logger.getLogger(Commands.class.getName());

    public static Iterable<UICommand> getEnabledCommands(Iterable<UICommand> commands, UIContext context) {
        LinkedList<UICommand> result = new LinkedList<UICommand>();
        for (UICommand uiCommand : commands) {
            try {
                if (!Commands.isEnabled(uiCommand, context)) continue;
                result.add(uiCommand);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not call method " + UICommand.class.getName() + "`isEnabled(UIContext ctx)` of type [" + uiCommand + "] with Metadata [" + Commands.getMetadata(uiCommand, context) + "].", e);
            }
        }
        return result;
    }

    public static boolean isEnabled(UICommand command, UIContext context) {
        return command.isEnabled(context) && !(command instanceof UIWizardStep);
    }

    private static String getMetadata(UICommand command, UIContext context) {
        String result = "!!! Failed to load Metadata via `" + UICommand.class.getName() + ".getMetadata(UIContext ctx)` !!!";
        try {
            UICommandMetadata metadata = command.getMetadata(context);
            result = metadata.toString();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not call method " + UICommand.class.getName() + "`getMetadata(UIContext ctx)` of type [" + command + "].", e);
        }
        return result;
    }

    private static String shellifyName(String name) {
        String newName = WHITESPACES.matcher(name.trim()).replaceAll("-");
        if (newName.endsWith("-")) {
            newName = newName.substring(0, newName.length() - 1);
        }
        return COLONS.matcher(newName).replaceAll("");
    }

    public static String shellifyCommandName(String name) {
        return Commands.shellifyName(name).toLowerCase();
    }

    public static String shellifyOptionName(String name) {
        return Commands.shellifyName(name);
    }

    public static String shellifyOptionValue(String value) {
        return COLONS.matcher(WHITESPACES.matcher(value.trim()).replaceAll("_")).replaceAll("").toUpperCase();
    }

    public static String shellifyOptionNameDashed(String name) {
        String shellName = Commands.shellifyName(name);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < shellName.length(); ++i) {
            char c = shellName.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    char nextChar;
                    char previousChar = shellName.charAt(i - 1);
                    char c2 = nextChar = i + 1 < shellName.length() ? shellName.charAt(i + 1) : (char)'\u0000';
                    if (previousChar != '-' && (!Character.isUpperCase(previousChar) || Character.isLowerCase(nextChar))) {
                        sb.append('-');
                    }
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

