/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.bootstrap;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.impl.addons.AddonRepositoryImpl;
import org.jboss.forge.furnace.manager.impl.AddonManagerImpl;
import org.jboss.forge.furnace.manager.maven.addon.MavenAddonDependencyResolver;
import org.jboss.forge.furnace.manager.request.InstallRequest;
import org.jboss.forge.furnace.manager.request.RemoveRequest;
import org.jboss.forge.furnace.manager.spi.AddonDependencyResolver;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.AddonRepositoryMode;
import org.jboss.forge.furnace.repositories.MutableAddonRepository;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.furnace.versions.Versions;

public class Bootstrap {
    private static final String FORGE_ADDON_GROUP_ID = "org.jboss.forge.addon:";
    private final Furnace furnace;
    private boolean exitAfter = false;
    private boolean batchMode = false;

    public static void main(String[] args) {
        ArrayList<String> bootstrapArgs = new ArrayList<String>();
        Properties systemProperties = System.getProperties();
        for (String arg : args) {
            if (arg.startsWith("-D")) {
                String value;
                String name;
                int index = arg.indexOf("=");
                if (index == -1) {
                    name = arg.substring(2);
                    value = "true";
                } else {
                    name = arg.substring(2, index);
                    value = arg.substring(index + 1);
                }
                systemProperties.setProperty(name, value);
                continue;
            }
            bootstrapArgs.add(arg);
        }
        String logDir = systemProperties.getProperty("org.jboss.forge.log.file", new File(OperatingSystemUtils.getUserForgeDir(), "log/forge.log").getAbsolutePath());
        systemProperties.setProperty("org.jboss.forge.log.file", logDir);
        String logManagerName = Bootstrap.getServiceName(Bootstrap.class.getClassLoader(), "java.util.logging.LogManager");
        if (logManagerName != null) {
            systemProperties.setProperty("java.util.logging.manager", logManagerName);
        }
        Bootstrap bootstrap = new Bootstrap(bootstrapArgs.toArray(new String[bootstrapArgs.size()]));
        bootstrap.start();
    }

    private Bootstrap(String[] args) {
        boolean listInstalled = false;
        String installAddon = null;
        String removeAddon = null;
        this.furnace = ServiceLoader.load(Furnace.class).iterator().next();
        this.furnace.setArgs(args);
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if ("--install".equals(args[i]) || "-i".equals(args[i])) {
                    installAddon = args[++i];
                    continue;
                }
                if ("--remove".equals(args[i]) || "-r".equals(args[i])) {
                    removeAddon = args[++i];
                    continue;
                }
                if ("--list".equals(args[i]) || "-l".equals(args[i])) {
                    listInstalled = true;
                    continue;
                }
                if ("--addonDir".equals(args[i]) || "-a".equals(args[i])) {
                    this.furnace.addRepository(AddonRepositoryMode.MUTABLE, new File(args[++i]));
                    continue;
                }
                if ("--immutableAddonDir".equals(args[i]) || "-m".equals(args[i])) {
                    this.furnace.addRepository(AddonRepositoryMode.IMMUTABLE, new File(args[++i]));
                    continue;
                }
                if ("--batchMode".equals(args[i]) || "-b".equals(args[i])) {
                    this.batchMode = true;
                    this.furnace.setServerMode(false);
                    continue;
                }
                if ("--debug".equals(args[i]) || "-d".equals(args[i])) continue;
                if ("--version".equals(args[i]) || "-v".equals(args[i])) {
                    System.out.println("Forge version " + AddonRepositoryImpl.getRuntimeAPIVersion());
                    this.exitAfter = true;
                    continue;
                }
                System.out.println("Unknown option: " + args[i]);
            }
        }
        if (!this.containsMutableRepository(this.furnace.getRepositories())) {
            this.furnace.addRepository(AddonRepositoryMode.MUTABLE, new File(OperatingSystemUtils.getUserForgeDir(), "addons"));
        }
        if (listInstalled) {
            this.list();
        }
        if (installAddon != null) {
            this.install(installAddon);
        }
        if (removeAddon != null) {
            this.remove(removeAddon);
        }
    }

    private boolean containsMutableRepository(List<AddonRepository> repositories) {
        boolean result = false;
        for (AddonRepository repository : repositories) {
            if (!(repository instanceof MutableAddonRepository)) continue;
            result = true;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void list() {
        try {
            for (AddonRepository repository : this.furnace.getRepositories()) {
                System.out.println(repository.getRootDirectory().getCanonicalPath() + ":");
                List addons = repository.listEnabled();
                for (AddonId addon : addons) {
                    System.out.println(addon.toCoordinates());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("> Forge version [" + AddonRepositoryImpl.getRuntimeAPIVersion() + "]");
        }
        finally {
            this.exitAfter = true;
        }
    }

    private List<AddonId> getEnabledAddonIds() {
        ArrayList<AddonId> result = new ArrayList<AddonId>();
        for (AddonRepository repository : this.furnace.getRepositories()) {
            List addons = repository.listEnabled();
            result.addAll(addons);
        }
        return result;
    }

    private void start() {
        if (!this.exitAfter) {
            String result;
            List<AddonId> addonIds;
            if (!this.batchMode && (addonIds = this.getEnabledAddonIds()).isEmpty() && !"n".equalsIgnoreCase((result = System.console().readLine("There are no addons installed; install core addons now? [Y,n] ", new Object[0])).trim())) {
                this.install("core");
            }
            this.furnace.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install(String addonCoordinates) {
        Version runtimeAPIVersion = AddonRepositoryImpl.getRuntimeAPIVersion();
        try {
            String result;
            AddonId addon;
            MavenAddonDependencyResolver resolver = new MavenAddonDependencyResolver();
            AddonManagerImpl addonManager = new AddonManagerImpl(this.furnace, (AddonDependencyResolver)resolver);
            if (addonCoordinates.contains(",")) {
                addon = addonCoordinates.contains(":") ? AddonId.fromCoordinates((String)addonCoordinates) : AddonId.fromCoordinates((String)(FORGE_ADDON_GROUP_ID + addonCoordinates));
            } else {
                String coordinate = FORGE_ADDON_GROUP_ID + addonCoordinates;
                AddonId[] versions = (AddonId[])resolver.resolveVersions(coordinate).get();
                if (versions.length == 0) {
                    throw new IllegalArgumentException("No Artifact version found for " + coordinate);
                }
                AddonId selected = null;
                for (int i = versions.length - 1; selected == null && i >= 0; --i) {
                    String apiVersion = (String)resolver.resolveAPIVersion(versions[i]).get();
                    if (apiVersion == null || !Versions.isApiCompatible((Version)runtimeAPIVersion, (Version)new SingleVersion(apiVersion))) continue;
                    selected = versions[i];
                }
                if (selected == null) {
                    throw new IllegalArgumentException("No compatible addon API version found for " + coordinate + " for API " + runtimeAPIVersion);
                }
                addon = selected;
            }
            InstallRequest request = addonManager.install(addon);
            System.out.println(request);
            if (!this.batchMode && "n".equalsIgnoreCase((result = System.console().readLine("Confirm installation [Y/n]? ", new Object[0])).trim())) {
                System.out.println("Installation aborted.");
                return;
            }
            request.perform();
            System.out.println("Installation completed successfully.");
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("> Forge version [" + runtimeAPIVersion + "]");
        }
        finally {
            this.exitAfter = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(String addonCoordinates) {
        try {
            String coordinates;
            MavenAddonDependencyResolver resolver = new MavenAddonDependencyResolver();
            AddonManagerImpl addonManager = new AddonManagerImpl(this.furnace, (AddonDependencyResolver)resolver);
            AddonId addon = null;
            if (addonCoordinates.contains(",")) {
                addon = addonCoordinates.contains(":") ? AddonId.fromCoordinates((String)addonCoordinates) : AddonId.fromCoordinates((String)(FORGE_ADDON_GROUP_ID + addonCoordinates));
                coordinates = addon.getName();
            } else {
                coordinates = FORGE_ADDON_GROUP_ID + addonCoordinates;
            }
            block6: for (AddonRepository repository : this.furnace.getRepositories()) {
                for (AddonId id : repository.listEnabled()) {
                    String result;
                    if (!coordinates.equals(id.getName())) continue;
                    addon = id;
                    if (!(repository instanceof MutableAddonRepository)) break block6;
                    RemoveRequest request = addonManager.remove(id, repository);
                    System.out.println(request);
                    if (!this.batchMode && "n".equalsIgnoreCase((result = System.console().readLine("Confirm uninstallation [Y/n]? ", new Object[0])).trim())) {
                        System.out.println("Uninstallation aborted.");
                        return;
                    }
                    request.perform();
                    System.out.println("Uninstallation completed successfully.");
                    System.out.println();
                    break block6;
                }
            }
            if (addon == null) {
                throw new IllegalArgumentException("No addon exists with id " + coordinates);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("> Forge version [" + AddonRepositoryImpl.getRuntimeAPIVersion() + "]");
        }
        finally {
            this.exitAfter = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getServiceName(ClassLoader classLoader, String className) {
        InputStream stream = classLoader.getResourceAsStream("META-INF/services/" + className);
        if (stream != null) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(stream));
                while ((line = reader.readLine()) != null) {
                    int i = line.indexOf(35);
                    if (i != -1) {
                        line = line.substring(0, i);
                    }
                    if ((line = line.trim()).length() == 0) continue;
                    String string = line;
                    return string;
                }
            }
            catch (IOException ignored) {
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ignored) {}
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return null;
    }
}

