/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.dev.i18n;

import java.io.FileNotFoundException;
import javax.inject.Inject;
import org.jboss.forge.resources.EntryResource;
import org.jboss.forge.resources.PropertiesFileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.Wait;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresResource;
import org.jboss.forge.shell.plugins.Topic;

@Alias(value="ls")
@RequiresResource(value={PropertiesFileResource.class})
@Topic(value="File & Resources")
@Help(value="Prints the contents of the current Properties file")
public class LsBundlePlugin
implements Plugin {
    @Inject
    private Wait wait;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultCommand
    public void run(@Option(description="path", defaultValue=".") Resource<?>[] paths, PipeOut out) throws FileNotFoundException {
        try {
            this.wait.start("Listing Resource Bundle Content ...");
            out.println();
            out.println();
            for (Resource<?> path : paths) {
                if (!(path instanceof PropertiesFileResource)) continue;
                PropertiesFileResource propResource = (PropertiesFileResource)path;
                for (Resource resource : propResource.listResources()) {
                    EntryResource entryResource = (EntryResource)resource;
                    out.print(ShellColor.BOLD, (String)entryResource.getKey() + ": ");
                    out.println((String)entryResource.getValue());
                }
                out.println();
            }
        }
        finally {
            this.wait.stop();
        }
    }
}

